/*-
 * Copyright (C) 2008 Erik Larsson
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.catacombae.hfsexplorer.types.hfs;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;

/** This class was generated by CStructToJavaClass. */
public abstract class CatDataRec implements StaticStruct, PrintableStruct, StructElements {
    /** One of the possible values for cdrType. */
    public static final byte HFS_DIRECTORY_RECORD = 1;
    /** One of the possible values for cdrType. */
    public static final byte HFS_FILE_RECORD = 2;
    /** One of the possible values for cdrType. */
    public static final byte HFS_DIRECTORY_THREAD_RECORD = 3;
    /** One of the possible values for cdrType. */
    public static final byte HFS_FILE_THREAD_RECORD = 4;

    /*
     * struct CatDataRec
     * size: 2 bytes
     * description: 
     * 
     * BP  Size  Type   Identifier  Description             
     * -----------------------------------------------------
     * 0   1     SInt8  cdrType     record type (SignedByte)
     * 1   1     SInt8  cdrResrv2   reserved (SignedByte)   
     */
    
    public static final int STRUCTSIZE = 2;
    
    private final byte[] cdrType = new byte[1];
    private final byte[] cdrResrv2 = new byte[1];
    
    protected CatDataRec(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, cdrType, 0, 1);
        System.arraycopy(data, offset + 1, cdrResrv2, 0, 1);
    }

    public static int length() { return STRUCTSIZE; }
    
    /** record type (SignedByte) */
    public byte getCdrType() { return Util.readByteBE(cdrType); }
    /** reserved (SignedByte) */
    public byte getCdrResrv2() { return Util.readByteBE(cdrResrv2); }
    
    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " cdrType: " + Util.unsign(getCdrType()));
        ps.println(prefix + " cdrResrv2: " + Util.unsign(getCdrResrv2()));
    }
    
    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "CatDataRec:");
        printFields(ps, prefix);
    }
    
    public byte[] getBytes() {
        byte[] result = new byte[STRUCTSIZE];
        int offset = 0;
        System.arraycopy(cdrType, 0, result, offset, cdrType.length); offset += cdrType.length;
        System.arraycopy(cdrResrv2, 0, result, offset, cdrResrv2.length); offset += cdrResrv2.length;
        return result;
    }
    
    //@Override
    protected void addSuperStructElements(DictionaryBuilder db) {
        db.addUIntBE("cdrType", cdrType, "Record type", HEXADECIMAL);
        db.addUIntBE("cdrResrv2", cdrResrv2, "Reserved", HEXADECIMAL);
    }
}
