/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* Generated by Together */

package ghidra.program.model.symbol;

/**
 * Class to define reference types.
 */
public abstract class RefType {

	//
	// NOTE:
	// When creating a new flow type, be sure
	// to add code to the RefTypeFactory
	//

	static final byte __INVALID = -2;

	// CODE REFERENCE TYPES
	static final byte __UNKNOWNFLOW = -1;
	static final byte __FALL_THROUGH = 0;
	static final byte __UNCONDITIONAL_JUMP = 1;
	static final byte __CONDITIONAL_JUMP = 2;
	static final byte __UNCONDITIONAL_CALL = 3;
	static final byte __CONDITIONAL_CALL = 4;
	static final byte __TERMINATOR = 5;
	static final byte __COMPUTED_JUMP = 6;
	static final byte __CONDITIONAL_TERMINATOR = 7;
	static final byte __COMPUTED_CALL = 8;

	static final byte __INDIRECTION = 9;

	static final byte __CALL_TERMINATOR = 10;
	static final byte __JUMP_TERMINATOR = 11;

	static final byte __CONDITIONAL_COMPUTED_JUMP = 12;
	static final byte __CONDITIONAL_COMPUTED_CALL = 13;

	static final byte __CONDITIONAL_CALL_TERMINATOR = 14;
	static final byte __COMPUTED_CALL_TERMINATOR = 15;

	// DATA REFERENCE TYPES
	static final byte __UNKNOWNDATA = 100;
	static final byte __READ = 101;
	static final byte __WRITE = 102;
	static final byte __READ_WRITE = 103;
	static final byte __READ_IND = 104;
	static final byte __WRITE_IND = 105;
	static final byte __READ_WRITE_IND = 106;
	static final byte __UNKNOWNPARAM = 107;
	@Deprecated
	static final byte __STACK_READ = 110; // Use __READ instead
	@Deprecated
	static final byte __STACK_WRITE = 111; // Use __WRITE instead
	static final byte __EXTERNAL_REF = 113;
	static final byte __UNKNOWNDATA_IND = 114;

	static final byte __DYNAMICDATA = 127;

	public static final FlowType INVALID =
		new FlowType(__INVALID, "INVALID", true, false, false, false, false, false);
	public static final FlowType FLOW =
		new FlowType(__UNKNOWNFLOW, "FLOW", true, false, false, false, false, false);
	public static final FlowType FALL_THROUGH =
		new FlowType(__FALL_THROUGH, "FALL_THROUGH", true, false, false, false, false, false);
	public static final FlowType UNCONDITIONAL_JUMP = new FlowType(__UNCONDITIONAL_JUMP,
		"UNCONDITIONAL_JUMP", false, false, true, false, false, false);
	public static final FlowType CONDITIONAL_JUMP =
		new FlowType(__CONDITIONAL_JUMP, "CONDITIONAL_JUMP", true, false, true, false, false, true);
	public static final FlowType UNCONDITIONAL_CALL = new FlowType(__UNCONDITIONAL_CALL,
		"UNCONDITIONAL_CALL", true, true, false, false, false, false);
	public static final FlowType CONDITIONAL_CALL =
		new FlowType(__CONDITIONAL_CALL, "CONDITIONAL_CALL", true, true, false, false, false, true);
	public static final FlowType TERMINATOR =
		new FlowType(__TERMINATOR, "TERMINATOR", false, false, false, true, false, false);
	public static final FlowType COMPUTED_JUMP =
		new FlowType(__COMPUTED_JUMP, "COMPUTED_JUMP", false, false, true, false, true, false);
	public static final FlowType CONDITIONAL_TERMINATOR = new FlowType(__CONDITIONAL_TERMINATOR,
		"CONDITIONAL_TERMINATOR", true, false, false, true, false, true);
	public static final FlowType COMPUTED_CALL =
		new FlowType(__COMPUTED_CALL, "COMPUTED_CALL", true, true, false, false, true, false);
	public static final FlowType CALL_TERMINATOR =
		new FlowType(__CALL_TERMINATOR, "CALL_TERMINATOR", false, true, false, true, false, false);
	public static final FlowType COMPUTED_CALL_TERMINATOR = new FlowType(__COMPUTED_CALL_TERMINATOR,
		"COMPUTED_CALL_TERMINATOR", false, true, false, true, true, false);
	public static final FlowType CONDITIONAL_CALL_TERMINATOR =
		new FlowType(__CONDITIONAL_CALL_TERMINATOR, "CONDITIONAL_CALL_TERMINATOR", false, true,
			false, true, false, true);
	public static final FlowType CONDITIONAL_COMPUTED_CALL =
		new FlowType(__CONDITIONAL_COMPUTED_CALL, "CONDITIONAL_COMPUTED_CALL", true, true, false,
			false, true, true);
	public static final FlowType CONDITIONAL_COMPUTED_JUMP =
		new FlowType(__CONDITIONAL_COMPUTED_JUMP, "CONDITIONAL_COMPUTED_JUMP", true, false, true,
			false, true, true);
	public static final FlowType JUMP_TERMINATOR =
		new FlowType(__JUMP_TERMINATOR, "JUMP TERMINATOR", false, false, true, true, false, false);
	public static final FlowType INDIRECTION =
		new FlowType(__INDIRECTION, "INDIRECTION", false, false, false, false, false, false);

	/**
	 * Reference type is unknown.
	 */

	public static final RefType THUNK = new DataRefType(__DYNAMICDATA, "THUNK", 0);

	/**
	 * Reference type assigned when data access is unknown.
	 */
	public static final RefType DATA = new DataRefType(__UNKNOWNDATA, "DATA", 0);

	/**
	 * Reference type assigned when data (constant or pointer) is passed to a function
	 */
	public static final RefType PARAM = new DataRefType(__UNKNOWNPARAM, "PARAM", 0);

	public static final RefType DATA_IND =
		new DataRefType(__UNKNOWNDATA_IND, "DATA_IND", DataRefType.INDX);

	/**
	 * Reference type assigned when data is being read.
	 */
	public static final RefType READ = new DataRefType(__READ, "READ", DataRefType.READX);
	/**
	 * Reference type assigned when data is being written.
	 */
	public static final RefType WRITE = new DataRefType(__WRITE, "WRITE", DataRefType.WRITEX);
	/**
	 * Reference type assigned when data is read and written.
	 */
	public static final RefType READ_WRITE =
		new DataRefType(__READ_WRITE, "READ_WRITE", DataRefType.READX | DataRefType.WRITEX);
	/**
	 * Reference type assigned when data is being read.
	 */
	public static final RefType READ_IND =
		new DataRefType(__READ_IND, "READ_IND", DataRefType.READX | DataRefType.INDX);
	/**
	 * Reference type assigned when data is being written.
	 */
	public static final RefType WRITE_IND =
		new DataRefType(__WRITE_IND, "WRITE_IND", DataRefType.WRITEX | DataRefType.INDX);
	/**
	 * Reference type assigned when data is read and written.
	 */
	public static final RefType READ_WRITE_IND = new DataRefType(__READ_WRITE_IND, "READ_WRITE_IND",
		DataRefType.READX | DataRefType.WRITEX | DataRefType.INDX);
	/**
	 * Reference type assigned for stack variable being read.
	 * @deprecated use {@link RefType#READ} instead
	 */
	@Deprecated
	public static final RefType STACK_READ =
		new DataRefType(__STACK_READ, "STACK_READ", DataRefType.READX);
	/**
	 * Reference type assigned for stack variable being written.
	 * @deprecated use {@link RefType#WRITE} instead
	 */
	@Deprecated
	public static final RefType STACK_WRITE =
		new DataRefType(__STACK_WRITE, "STACK_WRITE", DataRefType.WRITEX);
	/**
	 * Reference type used internally to identify external entry points.  
	 * The use of this RefType for references to external library data or functions 
	 * is deprecated and should not be used for that purpose.
	 */
	public static final RefType EXTERNAL_REF = new DataRefType(__EXTERNAL_REF, "EXTERNAL", 0);

	private byte type;
	private String name;

	/**
	 * Constructor
	 */
	protected RefType(byte type, String name) {
		this.type = type;
		this.name = name;
	}

	/**
	 * Get the int value for this RefType object.
	 */
	public byte getValue() {
		return type;
	}

	/**
	 * Returns true if the reference is to data
	 */
	public boolean isData() {
		return false;
	}

	/**
	 * Returns true if the reference is a read.
	 */
	public boolean isRead() {
		return false;
	}

	/**
	 * Returns true if the reference is a write.
	 */
	public boolean isWrite() {
		return false;
	}

	/**
	 * Returns true if the reference is indirect
	 */
	public boolean isIndirect() {
		if (this == INDIRECTION) {
			return true;
		}
		return false;
	}

	/**
	 * Returns true if the reference is an instruction flow reference.
	 */
	public boolean isFlow() {
		return false;
	}

	/**
	 * Return true if this flow type is one that does not cause
	 * a break in control flow.
	 */
	public final boolean isFallthrough() {
		return this == FALL_THROUGH;
	}

	/**
	 * Returns true if this flow type can fall through.
	 */
	public boolean hasFallthrough() {
		return false;
	}

	/**
	 * Returns true if the flow is call
	 */
	public boolean isCall() {
		return false;
	}

	/**
	 * Returns true if the flow is jump
	 */
	public boolean isJump() {
		return false;
	}

	/**
	 * Returns true if the flow is an unconditional call or jump.
	 */
	public boolean isUnConditional() {
		return !isConditional();
	}

	/**
	 * Returns true if the flow is a conditiona call or jump.
	 */
	public boolean isConditional() {
		return false;
	}

	/**
	 * Returns true if the flow is a computed call or compute jump.
	 */
	public boolean isComputed() {
		return false;
	}

	/**
	 * returns true if this instruction terminates.
	 */
	public boolean isTerminal() {
		return false;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (obj == null || !getClass().equals(obj.getClass())) {
			return false;
		}
		RefType other = (RefType) obj;
		return type == other.type;
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return type;
	}

	/**
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return name;
	}

	/**
	 * Returns name of ref-type
	 */
	public String getName() {
		return name;
	}

}
