/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.util.DeprecationLogger;

public class DefaultSourceSetOutput
extends CompositeFileCollection
implements SourceSetOutput {
    private final ConfigurableFileCollection outputDirectories;
    private Object resourcesDir;
    private final ConfigurableFileCollection classesDirs;
    private final ConfigurableFileCollection dirs;
    private final ConfigurableFileCollection generatedSourcesDirs;
    private final FileResolver fileResolver;
    private final DefaultTaskDependency compileTasks;

    public DefaultSourceSetOutput(String sourceSetDisplayName, FileResolver fileResolver, FileCollectionFactory fileCollectionFactory) {
        this.fileResolver = fileResolver;
        this.classesDirs = fileCollectionFactory.configurableFiles(sourceSetDisplayName + " classesDirs");
        this.classesDirs.builtBy(new Object[]{this});
        this.outputDirectories = fileCollectionFactory.configurableFiles(sourceSetDisplayName + " classes");
        this.outputDirectories.from(new Object[]{new Callable(){

            public Object call() {
                return DefaultSourceSetOutput.this.classesDirs;
            }
        }, new Callable(){

            public Object call() {
                return DefaultSourceSetOutput.this.getResourcesDir();
            }
        }});
        this.dirs = fileCollectionFactory.configurableFiles(sourceSetDisplayName + " dirs");
        this.generatedSourcesDirs = fileCollectionFactory.configurableFiles(sourceSetDisplayName + " generatedSourcesDirs");
        this.compileTasks = new DefaultTaskDependency();
    }

    public void visitContents(FileCollectionResolveContext context) {
        context.add((Object)this.outputDirectories);
    }

    public String getDisplayName() {
        return this.outputDirectories.toString();
    }

    public ConfigurableFileCollection getClassesDirs() {
        return this.classesDirs;
    }

    public void addClassesDir(Callable<File> classesDir) {
        this.classesDirs.from(new Object[]{classesDir});
    }

    @Override
    public boolean isLegacyLayout() {
        DeprecationLogger.nagUserOfDiscontinuedProperty((String)"legacyLayout", (String)"The method always returns false.");
        return false;
    }

    @Override
    @Nullable
    public File getResourcesDir() {
        if (this.resourcesDir == null) {
            return null;
        }
        return this.fileResolver.resolve(this.resourcesDir);
    }

    @Override
    public void setResourcesDir(File resourcesDir) {
        this.resourcesDir = resourcesDir;
    }

    @Override
    public void setResourcesDir(Object resourcesDir) {
        this.resourcesDir = resourcesDir;
    }

    public void builtBy(Object ... taskPaths) {
        this.outputDirectories.builtBy(taskPaths);
    }

    @Override
    public void dir(Object dir) {
        this.dir(Collections.emptyMap(), dir);
    }

    @Override
    public void dir(Map<String, Object> options, Object dir) {
        this.dirs.from(new Object[]{dir});
        this.outputDirectories.from(new Object[]{dir});
        Object builtBy = options.get("builtBy");
        if (builtBy != null) {
            this.builtBy(builtBy);
            this.dirs.builtBy(new Object[]{builtBy});
        }
    }

    @Override
    public FileCollection getDirs() {
        return this.dirs;
    }

    public ConfigurableFileCollection getGeneratedSourcesDirs() {
        return this.generatedSourcesDirs;
    }

    public void registerCompileTask(Provider<? extends AbstractCompile> compileTask) {
        this.compileTasks.add(new Object[]{compileTask});
    }

    public TaskDependency getCompileDependencies() {
        return this.compileTasks;
    }
}

