/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.Serializable;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.tasks.compile.AnnotationProcessorDiscoveringCompiler;
import org.gradle.api.internal.tasks.compile.ApiGroovyCompiler;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompiler;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaHomeBasedJavaCompilerFactory;
import org.gradle.api.internal.tasks.compile.JdkJavaCompiler;
import org.gradle.api.internal.tasks.compile.NormalizingGroovyCompiler;
import org.gradle.api.internal.tasks.compile.daemon.DaemonGroovyCompiler;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDetector;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.GroovyCompileOptions;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerFactory;
import org.gradle.process.internal.DefaultExecActionFactory;
import org.gradle.process.internal.ExecHandleFactory;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.IsolatedClassloaderWorkerFactory;
import org.gradle.workers.internal.WorkerDaemonFactory;
import org.gradle.workers.internal.WorkerFactory;

public class GroovyCompilerFactory
implements CompilerFactory<GroovyJavaJointCompileSpec> {
    private final WorkerDaemonFactory workerDaemonFactory;
    private final IsolatedClassloaderWorkerFactory inProcessWorkerFactory;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final AnnotationProcessorDetector processorDetector;
    private final JvmVersionDetector jvmVersionDetector;
    private final WorkerDirectoryProvider workerDirectoryProvider;
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;

    public GroovyCompilerFactory(WorkerDaemonFactory workerDaemonFactory, IsolatedClassloaderWorkerFactory inProcessWorkerFactory, JavaForkOptionsFactory forkOptionsFactory, AnnotationProcessorDetector processorDetector, JvmVersionDetector jvmVersionDetector, WorkerDirectoryProvider workerDirectoryProvider, ClassPathRegistry classPathRegistry, ClassLoaderRegistry classLoaderRegistry, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        this.workerDaemonFactory = workerDaemonFactory;
        this.inProcessWorkerFactory = inProcessWorkerFactory;
        this.forkOptionsFactory = forkOptionsFactory;
        this.processorDetector = processorDetector;
        this.jvmVersionDetector = jvmVersionDetector;
        this.workerDirectoryProvider = workerDirectoryProvider;
        this.classPathRegistry = classPathRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
    }

    public Compiler<GroovyJavaJointCompileSpec> newCompiler(GroovyJavaJointCompileSpec spec) {
        GroovyCompileOptions groovyOptions = spec.getGroovyCompileOptions();
        Object workerFactory = groovyOptions.isFork() ? this.workerDaemonFactory : this.inProcessWorkerFactory;
        DaemonGroovyCompiler groovyCompiler = new DaemonGroovyCompiler(this.workerDirectoryProvider.getWorkingDirectory(), DaemonSideCompiler.class, this.classPathRegistry, (WorkerFactory)workerFactory, this.classLoaderRegistry, this.forkOptionsFactory, this.jvmVersionDetector, this.actionExecutionSpecFactory);
        return new AnnotationProcessorDiscoveringCompiler((Compiler)new NormalizingGroovyCompiler((Compiler<GroovyJavaJointCompileSpec>)groovyCompiler), this.processorDetector);
    }

    static class DaemonSideCompiler
    implements Compiler<GroovyJavaJointCompileSpec>,
    Serializable {
        DaemonSideCompiler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WorkResult execute(GroovyJavaJointCompileSpec spec) {
            WorkResult workResult;
            DefaultExecActionFactory execHandleFactory = DefaultExecActionFactory.root();
            try {
                Object javaCompiler = CommandLineJavaCompileSpec.class.isAssignableFrom(spec.getClass()) ? new CommandLineJavaCompiler((ExecHandleFactory)execHandleFactory) : new JdkJavaCompiler((Factory)new JavaHomeBasedJavaCompilerFactory());
                ApiGroovyCompiler groovyCompiler = new ApiGroovyCompiler((Compiler<JavaCompileSpec>)javaCompiler);
                workResult = groovyCompiler.execute((CompileSpec)spec);
            }
            catch (Throwable throwable) {
                CompositeStoppable.stoppable((Object[])new Object[]{execHandleFactory}).stop();
                throw throwable;
            }
            CompositeStoppable.stoppable((Object[])new Object[]{execHandleFactory}).stop();
            return workResult;
        }
    }
}

