/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.run;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.internal.UncheckedException;
import org.gradle.util.CollectionUtils;

class AssetsClassLoader
extends ClassLoader {
    private final List<AssetDir> assetDirs;

    AssetsClassLoader(ClassLoader parent, List<AssetDir> assetDirs) {
        super(parent);
        this.assetDirs = assetDirs;
    }

    @Override
    protected URL findResource(String name) {
        AssetDir assetDir = this.findResourceInAssetDir(name);
        if (assetDir != null) {
            return assetDir.toURL(name);
        }
        return null;
    }

    private AssetDir findResourceInAssetDir(final String name) {
        return (AssetDir)CollectionUtils.findFirst(this.assetDirs, (Spec)new Spec<AssetDir>(){

            public boolean isSatisfiedBy(AssetDir assetDir) {
                return assetDir.exists(name);
            }
        });
    }

    public static class AssetDir {
        private final String prefix;
        private final File dir;

        public AssetDir(String prefix, File dir) {
            this.prefix = prefix;
            this.dir = dir;
        }

        boolean exists(String name) {
            return name.startsWith(this.prefix) && this.resolve(name).isFile();
        }

        File resolve(String name) {
            return new File(this.dir, name.substring(this.prefix.length()));
        }

        URL toURL(String name) {
            try {
                return this.resolve(name).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }
}

