/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.extensions.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionNotApplicableException;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.LoadingOrder;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginAware;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;

public class ExtensionComponentAdapter
implements LoadingOrder.Orderable {
    public static final ExtensionComponentAdapter[] EMPTY_ARRAY = new ExtensionComponentAdapter[0];
    private final PluginDescriptor myPluginDescriptor;
    @NotNull
    private Object myImplementationClassOrName;
    private boolean myNotificationSent;
    private final String myOrderId;
    private final LoadingOrder myOrder;

    public ExtensionComponentAdapter(@NotNull String implementationClassName, @Nullable PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order2) {
        if (implementationClassName == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(0);
        }
        if (order2 == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(1);
        }
        this.myImplementationClassOrName = implementationClassName;
        this.myPluginDescriptor = pluginDescriptor;
        this.myOrderId = orderId;
        this.myOrder = order2;
    }

    @NotNull
    public Object createInstance(@Nullable PicoContainer container) {
        Object instance;
        try {
            Class<?> impl = this.getImplementationClass();
            ExtensionPointImpl.CHECK_CANCELED.run();
            instance = this.instantiateClass(impl, container);
            this.initInstance(instance);
        }
        catch (ExtensionNotApplicableException | ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            PluginId pluginId = this.myPluginDescriptor != null ? this.myPluginDescriptor.getPluginId() : null;
            throw new PicoPluginExtensionInitializationException(t.getMessage(), t, pluginId);
        }
        if (instance instanceof PluginAware) {
            ((PluginAware)instance).setPluginDescriptor(this.myPluginDescriptor);
        }
        Object object = instance;
        if (object == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(2);
        }
        return object;
    }

    @NotNull
    protected Object instantiateClass(@NotNull Class<?> clazz2, @Nullable PicoContainer container) {
        if (clazz2 == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(3);
        }
        Object obj = ReflectionUtil.newInstance(clazz2);
        if (obj == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(4);
        }
        return obj;
    }

    protected void initInstance(@NotNull Object instance) {
        if (instance == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(5);
        }
    }

    @Override
    public final LoadingOrder getOrder() {
        return this.myOrder;
    }

    @Override
    public final String getOrderId() {
        return this.myOrderId;
    }

    @Nullable
    public final PluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    @NotNull
    public final Class<?> getImplementationClass() {
        Class<?> implementationClassOrName = this.myImplementationClassOrName;
        if (implementationClassOrName instanceof String) {
            try {
                ClassLoader classLoader;
                ClassLoader classLoader2 = classLoader = this.myPluginDescriptor == null ? this.getClass().getClassLoader() : this.myPluginDescriptor.getPluginClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                this.myImplementationClassOrName = implementationClassOrName = Class.forName((String)((Object)implementationClassOrName), false, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        Class clazz2 = implementationClassOrName;
        if (clazz2 == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(6);
        }
        return clazz2;
    }

    @NotNull
    public final String getAssignableToClassName() {
        Object implementationClassOrName = this.myImplementationClassOrName;
        if (implementationClassOrName instanceof String) {
            String string = (String)implementationClassOrName;
            if (string == null) {
                ExtensionComponentAdapter.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = ((Class)implementationClassOrName).getName();
        if (string == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(8);
        }
        return string;
    }

    final boolean isNotificationSent() {
        return this.myNotificationSent;
    }

    final void setNotificationSent() {
        this.myNotificationSent = true;
    }

    public String toString() {
        return "ExtensionComponentAdapter[" + this.getAssignableToClassName() + "]: plugin=" + this.myPluginDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementationClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionComponentAdapter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionComponentAdapter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementationClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssignableToClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "instantiateClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

