/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.FrozenDocument;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.AnchorElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.MarkerCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import org.jetbrains.kotlin.com.intellij.util.CommonProcessors;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

class SmartPointerTracker {
    private static final ReferenceQueue<SmartPsiElementPointerImpl> ourQueue = new ReferenceQueue();
    private int nextAvailableIndex;
    private int size;
    private PointerReference[] references = new PointerReference[10];
    private final MarkerCache markerCache = new MarkerCache(this);
    private boolean mySorted;

    SmartPointerTracker() {
    }

    synchronized boolean addReference(@NotNull PointerReference reference, @NotNull SmartPsiElementPointerImpl pointer) {
        if (reference == null) {
            SmartPointerTracker.$$$reportNull$$$0(0);
        }
        if (pointer == null) {
            SmartPointerTracker.$$$reportNull$$$0(1);
        }
        if (!this.isActual(reference.file, reference.key)) {
            return false;
        }
        if (this.needsExpansion() || this.isTooSparse()) {
            this.resize();
            if (!this.isActual(reference.file, reference.key)) {
                throw new AssertionError();
            }
        }
        if (this.references[this.nextAvailableIndex] != null) {
            throw new AssertionError(this.references[this.nextAvailableIndex]);
        }
        SmartPointerTracker.storePointerReference(this.references, this.nextAvailableIndex++, reference);
        ++this.size;
        this.mySorted = false;
        if (((SelfElementInfo)pointer.getElementInfo()).hasRange()) {
            this.markerCache.rangeChanged();
        }
        return true;
    }

    private boolean isActual(@NotNull VirtualFile file2, @NotNull Key<SmartPointerTracker> key) {
        if (file2 == null) {
            SmartPointerTracker.$$$reportNull$$$0(2);
        }
        if (key == null) {
            SmartPointerTracker.$$$reportNull$$$0(3);
        }
        return file2.getUserData(key) == this;
    }

    private boolean needsExpansion() {
        return this.nextAvailableIndex >= this.references.length;
    }

    private boolean isTooSparse() {
        return this.nextAvailableIndex > this.size * 2;
    }

    private void resize() {
        PointerReference[] newReferences = new PointerReference[this.size * 3 / 2 + 1];
        int index2 = 0;
        for (PointerReference ref : this.references) {
            if (ref == null) continue;
            SmartPointerTracker.storePointerReference(newReferences, index2++, ref);
        }
        assert (index2 == this.size) : index2 + " != " + this.size;
        this.references = newReferences;
        this.nextAvailableIndex = index2;
    }

    synchronized void removeReference(@NotNull PointerReference reference) {
        int index2;
        if (reference == null) {
            SmartPointerTracker.$$$reportNull$$$0(4);
        }
        if ((index2 = reference.index) < 0) {
            return;
        }
        this.assertActual(reference.file, reference.key);
        if (this.references[index2] != reference) {
            throw new AssertionError((Object)("At " + index2 + " expected " + reference + ", found " + this.references[index2]));
        }
        this.references[index2].index = -1;
        this.references[index2] = null;
        if (--this.size == 0) {
            this.disconnectTracker(reference.file, reference.key);
        }
    }

    private void disconnectTracker(VirtualFile file2, Key<SmartPointerTracker> key) {
        if (!file2.replace(key, this, null)) {
            throw new IllegalStateException("Couldn't clear smart pointer tracker " + this + ", current " + file2.getUserData(key));
        }
    }

    private void assertActual(@NotNull VirtualFile file2, @NotNull Key<SmartPointerTracker> refKey) {
        if (file2 == null) {
            SmartPointerTracker.$$$reportNull$$$0(5);
        }
        if (refKey == null) {
            SmartPointerTracker.$$$reportNull$$$0(6);
        }
        if (!this.isActual(file2, refKey)) {
            SmartPointerTracker another = file2.getUserData(refKey);
            throw new AssertionError((Object)("Smart pointer list mismatch: size=" + this.size + ", ref.key=" + refKey + (another != null ? "; has another pointer list with size " + another.size : "")));
        }
    }

    private void processAlivePointers(@NotNull Processor<? super SmartPsiElementPointerImpl<?>> processor2) {
        if (processor2 == null) {
            SmartPointerTracker.$$$reportNull$$$0(7);
        }
        for (int i = 0; i < this.nextAvailableIndex; ++i) {
            PointerReference ref = this.references[i];
            if (ref == null) continue;
            if (!this.isActual(ref.file, ref.key)) {
                throw new AssertionError();
            }
            SmartPsiElementPointerImpl pointer = (SmartPsiElementPointerImpl)ref.get();
            if (pointer == null) {
                this.removeReference(ref);
                continue;
            }
            if (processor2.process(pointer)) continue;
            return;
        }
    }

    private void ensureSorted() {
        if (!this.mySorted) {
            ArrayList pointers = new ArrayList();
            this.processAlivePointers(new CommonProcessors.CollectProcessor(pointers));
            if (this.size != pointers.size()) {
                throw new AssertionError();
            }
            pointers.sort((p1, p2) -> MarkerCache.INFO_COMPARATOR.compare((SelfElementInfo)p1.getElementInfo(), (SelfElementInfo)p2.getElementInfo()));
            for (int i = 0; i < pointers.size(); ++i) {
                SmartPointerTracker.storePointerReference(this.references, i, ((SmartPsiElementPointerImpl)pointers.get((int)i)).pointerReference);
            }
            Arrays.fill(this.references, pointers.size(), this.nextAvailableIndex, null);
            this.nextAvailableIndex = pointers.size();
            this.mySorted = true;
        }
    }

    synchronized void updateMarkers(@NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        boolean stillSorted;
        if (frozen == null) {
            SmartPointerTracker.$$$reportNull$$$0(8);
        }
        if (events == null) {
            SmartPointerTracker.$$$reportNull$$$0(9);
        }
        if (!(stillSorted = this.markerCache.updateMarkers(frozen, events))) {
            this.mySorted = false;
        }
    }

    @Nullable
    synchronized Segment getUpdatedRange(@NotNull SelfElementInfo info2, @NotNull FrozenDocument document, @NotNull List<? extends DocumentEvent> events) {
        if (info2 == null) {
            SmartPointerTracker.$$$reportNull$$$0(10);
        }
        if (document == null) {
            SmartPointerTracker.$$$reportNull$$$0(11);
        }
        if (events == null) {
            SmartPointerTracker.$$$reportNull$$$0(12);
        }
        return this.markerCache.getUpdatedRange(info2, document, events);
    }

    @Nullable
    synchronized Segment getUpdatedRange(@NotNull PsiFile containingFile, @NotNull Segment segment, boolean isSegmentGreedy, @NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        if (containingFile == null) {
            SmartPointerTracker.$$$reportNull$$$0(13);
        }
        if (segment == null) {
            SmartPointerTracker.$$$reportNull$$$0(14);
        }
        if (frozen == null) {
            SmartPointerTracker.$$$reportNull$$$0(15);
        }
        if (events == null) {
            SmartPointerTracker.$$$reportNull$$$0(16);
        }
        return MarkerCache.getUpdatedRange(containingFile, segment, isSegmentGreedy, frozen, events);
    }

    synchronized void switchStubToAst(@NotNull AnchorElementInfo info2, @NotNull PsiElement element) {
        if (info2 == null) {
            SmartPointerTracker.$$$reportNull$$$0(17);
        }
        if (element == null) {
            SmartPointerTracker.$$$reportNull$$$0(18);
        }
        info2.switchToTreeRange(element);
        this.markerCache.rangeChanged();
        this.mySorted = false;
    }

    synchronized void fastenBelts(@NotNull SmartPointerManagerImpl manager) {
        if (manager == null) {
            SmartPointerTracker.$$$reportNull$$$0(19);
        }
        SmartPointerTracker.processQueue();
        this.processAlivePointers(pointer -> {
            pointer.getElementInfo().fastenBelt(manager);
            return true;
        });
    }

    synchronized void updatePointerTargetsAfterReparse() {
        this.processAlivePointers(pointer -> {
            if (!(pointer instanceof SmartPsiFileRangePointerImpl)) {
                SmartPointerTracker.updatePointerTarget(pointer, pointer.getPsiRange());
            }
            return true;
        });
    }

    private static <E extends PsiElement> void updatePointerTarget(@NotNull SmartPsiElementPointerImpl<E> pointer, @Nullable Segment pointerRange) {
        E actual;
        E cachedElement;
        if (pointer == null) {
            SmartPointerTracker.$$$reportNull$$$0(20);
        }
        if ((cachedElement = pointer.getCachedElement()) == null) {
            return;
        }
        boolean cachedValid = cachedElement.isValid();
        if (cachedValid) {
            if (pointerRange == null) {
                ((SelfElementInfo)pointer.getElementInfo()).switchToAnchor((PsiElement)cachedElement);
                return;
            }
            if (pointerRange.equals(cachedElement.getTextRange())) {
                return;
            }
        }
        if ((actual = pointer.doRestoreElement()) == null && cachedValid && ((SelfElementInfo)pointer.getElementInfo()).updateRangeToPsi(pointerRange, (PsiElement)cachedElement)) {
            return;
        }
        if (actual != cachedElement) {
            pointer.cacheElement(actual);
        }
    }

    private static void storePointerReference(PointerReference[] references, int index2, PointerReference ref) {
        references[index2] = ref;
        ref.index = index2;
    }

    synchronized List<SelfElementInfo> getSortedInfos() {
        this.ensureSorted();
        ArrayList<SelfElementInfo> infos2 = ContainerUtil.newArrayListWithCapacity(this.size);
        this.processAlivePointers(pointer -> {
            SelfElementInfo info2 = (SelfElementInfo)pointer.getElementInfo();
            if (!info2.hasRange()) {
                return false;
            }
            infos2.add(info2);
            return true;
        });
        return infos2;
    }

    synchronized int getSize() {
        return this.size;
    }

    static void processQueue() {
        PointerReference reference;
        while ((reference = (PointerReference)ourQueue.poll()) != null) {
            if (reference.get() != null) {
                throw new IllegalStateException("Queued reference has referent!");
            }
            SmartPointerTracker pointers = reference.file.getUserData(reference.key);
            if (pointers == null) continue;
            pointers.removeReference(reference);
        }
    }

    static {
        LowMemoryWatcher.register(() -> SmartPointerTracker.processQueue(), ApplicationManager.getApplication());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refKey";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frozen";
                break;
            }
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addReference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isActual";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "assertActual";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processAlivePointers";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "updateMarkers";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getUpdatedRange";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "switchStubToAst";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "fastenBelts";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePointerTarget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class PointerReference
    extends WeakReference<SmartPsiElementPointerImpl<?>> {
        @NotNull
        final VirtualFile file;
        @NotNull
        final Key<SmartPointerTracker> key;
        private int index;

        PointerReference(@NotNull SmartPsiElementPointerImpl<?> pointer, @NotNull VirtualFile containingFile, @NotNull Key<SmartPointerTracker> key) {
            if (pointer == null) {
                PointerReference.$$$reportNull$$$0(0);
            }
            if (containingFile == null) {
                PointerReference.$$$reportNull$$$0(1);
            }
            if (key == null) {
                PointerReference.$$$reportNull$$$0(2);
            }
            super(pointer, ourQueue);
            this.index = -2;
            this.file = containingFile;
            this.key = key;
            pointer.pointerReference = this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pointer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "containingFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerTracker$PointerReference";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

