/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassFilter;
import org.junit.platform.commons.util.Preconditions;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@API(status=API.Status.INTERNAL, since="1.1")
public class ModuleUtils {
    private static final Logger logger = LoggerFactory.getLogger(ModuleUtils.class);
    public static final String VERSION = "9";

    public static Set<String> findAllNonSystemBootModuleNames() {
        Set systemModules = ModuleFinder.ofSystem().findAll().stream().map(reference -> reference.descriptor().name()).collect(Collectors.toSet());
        return ModuleUtils.streamResolvedModules(name -> !systemModules.contains(name)).map(ResolvedModule::name).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static boolean isJavaPlatformModuleSystemAvailable() {
        return true;
    }

    public static Optional<String> getModuleName(Class<?> type) {
        Preconditions.notNull(type, "Class type must not be null");
        return Optional.ofNullable(type.getModule().getName());
    }

    public static Optional<String> getModuleVersion(Class<?> type) {
        Preconditions.notNull(type, "Class type must not be null");
        Module module = type.getModule();
        return module.isNamed() ? module.getDescriptor().rawVersion() : Optional.empty();
    }

    public static List<Class<?>> findAllClassesInModule(String moduleName, ClassFilter filter) {
        Preconditions.notBlank(moduleName, "Module name must not be null or empty");
        Preconditions.notNull(filter, "Class filter must not be null");
        logger.debug(() -> "Looking for classes in module: " + moduleName);
        Set<ModuleReference> moduleReferences = ModuleUtils.streamResolvedModules(Predicate.isEqual(moduleName)).map(ResolvedModule::reference).collect(Collectors.toSet());
        return ModuleUtils.scan(moduleReferences, filter, ModuleUtils.class.getClassLoader());
    }

    private static Stream<ResolvedModule> streamResolvedModules(Predicate<String> moduleNamePredicate) {
        Module module = ModuleUtils.class.getModule();
        ModuleLayer layer = module.getLayer();
        if (layer == null) {
            logger.config(() -> ModuleUtils.class + " is a member of " + module + " - using boot layer returned by ModuleLayer.boot() as fall-back.");
            layer = ModuleLayer.boot();
        }
        return ModuleUtils.streamResolvedModules(moduleNamePredicate, layer);
    }

    private static Stream<ResolvedModule> streamResolvedModules(Predicate<String> moduleNamePredicate, ModuleLayer layer) {
        logger.debug(() -> "Streaming modules for layer @" + System.identityHashCode(layer) + ": " + layer);
        Configuration configuration = layer.configuration();
        logger.debug(() -> "Module layer configuration: " + configuration);
        Stream stream = configuration.modules().stream();
        return stream.filter(module -> moduleNamePredicate.test(module.name()));
    }

    private static List<Class<?>> scan(Set<ModuleReference> references, ClassFilter filter, ClassLoader loader) {
        logger.debug(() -> "Scanning " + references.size() + " module references: " + references);
        ModuleReferenceScanner scanner = new ModuleReferenceScanner(filter, loader);
        ArrayList classes = new ArrayList();
        for (ModuleReference reference : references) {
            classes.addAll(scanner.scan(reference));
        }
        logger.debug(() -> "Found " + classes.size() + " classes: " + classes);
        return Collections.unmodifiableList(classes);
    }

    static class ModuleReferenceScanner {
        private final ClassFilter classFilter;
        private final ClassLoader classLoader;

        ModuleReferenceScanner(ClassFilter classFilter, ClassLoader classLoader) {
            this.classFilter = classFilter;
            this.classLoader = classLoader;
        }

        /*
         * Exception decompiling
         */
        List<Class<?>> scan(ModuleReference reference) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private String className(String resourceName) {
            resourceName = resourceName.substring(0, resourceName.length() - 6);
            resourceName = resourceName.replace('/', '.');
            return resourceName;
        }

        private Class<?> loadClassUnchecked(String binaryName) {
            try {
                return this.classLoader.loadClass(binaryName);
            }
            catch (ClassNotFoundException e) {
                throw new JUnitException("Failed to load class with name '" + binaryName + "'.", e);
            }
        }

        private static /* synthetic */ boolean lambda$scan$1(String name) {
            return !name.equals("module-info");
        }

        private static /* synthetic */ boolean lambda$scan$0(String name) {
            return name.endsWith(".class");
        }

        private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
            if (x0 != null) {
                try {
                    x1.close();
                }
                catch (Throwable throwable) {
                    x0.addSuppressed(throwable);
                }
            } else {
                x1.close();
            }
        }
    }
}

