/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScopeIdentifier;
import org.gradle.api.internal.initialization.DefaultClassLoaderScope;
import org.gradle.api.internal.initialization.DefaultDeprecatedClassLoader;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.internal.classpath.ClassPath;

public class DeprecatedClassLoaderScope
extends DefaultClassLoaderScope {
    private ClassPath deprecatedClasspath;
    private ClassLoader deprecatedExportClassloader;
    private ClassLoader deprecatedLocalClassloader;

    public DeprecatedClassLoaderScope(ClassLoaderScopeIdentifier id, ClassLoaderScope parent, ClassLoaderCache classLoaderCache, ClassPath deprecatedClasspath) {
        super(id, parent, classLoaderCache);
        this.deprecatedClasspath = deprecatedClasspath;
    }

    @Override
    public ClassLoaderScope export(ClassPath classPath) {
        this.export = this.export.plus(classPath);
        return this;
    }

    @Override
    public ClassLoaderScope deprecated() {
        return this;
    }

    @Override
    public ClassLoader getExportClassLoader() {
        if (this.deprecatedExportClassloader == null) {
            ClassLoaderId id = this.id.child("deprecated-only").exportId();
            this.deprecatedExportClassloader = new DefaultDeprecatedClassLoader(this.buildLockedLoader(id, this.deprecatedClasspath), super.getExportClassLoader());
        }
        return this.deprecatedExportClassloader;
    }

    @Override
    public ClassLoader getLocalClassLoader() {
        if (this.deprecatedLocalClassloader == null) {
            ClassLoaderId id = this.id.child("deprecated-only").localId();
            this.deprecatedLocalClassloader = new DefaultDeprecatedClassLoader(this.buildLockedLoader(id, this.deprecatedClasspath), super.getLocalClassLoader());
        }
        return this.deprecatedLocalClassloader;
    }

    @Override
    public ClassLoaderScope createChild(String name) {
        return new DeprecatedClassLoaderScope(this.id.child(name), this, this.classLoaderCache, this.deprecatedClasspath);
    }
}

