/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.changedetection.TaskExecutionMode;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.operations.ExecutingBuildOperation;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class DefaultTaskExecutionContext
implements TaskExecutionContext {
    private final LocalTaskNode localTaskNode;
    private AfterPreviousExecutionState afterPreviousExecution;
    private OverlappingOutputs overlappingOutputs;
    private ImmutableSortedMap<String, FileSystemSnapshot> outputFilesBeforeExecution;
    private TaskExecutionMode taskExecutionMode;
    private TaskProperties properties;
    private Long executionTime;
    private ExecutingBuildOperation snapshotTaskInputsBuildOperation;
    private final Timer executionTimer;

    public DefaultTaskExecutionContext(LocalTaskNode localTaskNode) {
        this.localTaskNode = localTaskNode;
        this.executionTimer = Time.startTimer();
    }

    @Override
    public LocalTaskNode getLocalTaskNode() {
        return this.localTaskNode;
    }

    @Override
    @Nullable
    public AfterPreviousExecutionState getAfterPreviousExecution() {
        return this.afterPreviousExecution;
    }

    @Override
    public void setAfterPreviousExecution(@Nullable AfterPreviousExecutionState afterPreviousExecution) {
        this.afterPreviousExecution = afterPreviousExecution;
    }

    @Override
    public ImmutableSortedMap<String, FileSystemSnapshot> getOutputFilesBeforeExecution() {
        return this.outputFilesBeforeExecution;
    }

    @Override
    public void setOutputFilesBeforeExecution(ImmutableSortedMap<String, FileSystemSnapshot> outputFilesBeforeExecution) {
        this.outputFilesBeforeExecution = outputFilesBeforeExecution;
    }

    @Override
    public Optional<OverlappingOutputs> getOverlappingOutputs() {
        return Optional.ofNullable(this.overlappingOutputs);
    }

    @Override
    public void setOverlappingOutputs(OverlappingOutputs overlappingOutputs) {
        this.overlappingOutputs = overlappingOutputs;
    }

    @Override
    public TaskExecutionMode getTaskExecutionMode() {
        return this.taskExecutionMode;
    }

    @Override
    public void setTaskExecutionMode(TaskExecutionMode taskExecutionMode) {
        this.taskExecutionMode = taskExecutionMode;
    }

    @Override
    public long markExecutionTime() {
        if (this.executionTime != null) {
            throw new IllegalStateException("execution time already set");
        }
        this.executionTime = this.executionTimer.getElapsedMillis();
        return this.executionTime;
    }

    @Override
    public void setTaskProperties(TaskProperties properties) {
        this.properties = properties;
    }

    @Override
    public TaskProperties getTaskProperties() {
        return this.properties;
    }

    @Override
    public Optional<ExecutingBuildOperation> removeSnapshotTaskInputsBuildOperation() {
        Optional<ExecutingBuildOperation> result = Optional.ofNullable(this.snapshotTaskInputsBuildOperation);
        this.snapshotTaskInputsBuildOperation = null;
        return result;
    }

    @Override
    public void setSnapshotTaskInputsBuildOperation(ExecutingBuildOperation snapshotTaskInputsBuildOperation) {
        this.snapshotTaskInputsBuildOperation = snapshotTaskInputsBuildOperation;
    }
}

