/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeCache<T>
extends Maybe<T>
implements MaybeObserver<T> {
    static final CacheDisposable[] EMPTY = new CacheDisposable[0];
    static final CacheDisposable[] TERMINATED = new CacheDisposable[0];
    final AtomicReference<MaybeSource<T>> source;
    final AtomicReference<CacheDisposable<T>[]> observers;
    T value;
    Throwable error;

    public MaybeCache(MaybeSource<T> source) {
        this.source = new AtomicReference<MaybeSource<T>>(source);
        this.observers = new AtomicReference<CacheDisposable[]>(EMPTY);
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        CacheDisposable<T> parent = new CacheDisposable<T>(observer, this);
        observer.onSubscribe(parent);
        if (this.add(parent)) {
            if (parent.isDisposed()) {
                this.remove(parent);
                return;
            }
        } else {
            if (!parent.isDisposed()) {
                Throwable ex = this.error;
                if (ex != null) {
                    observer.onError(ex);
                } else {
                    T v = this.value;
                    if (v != null) {
                        observer.onSuccess(v);
                    } else {
                        observer.onComplete();
                    }
                }
            }
            return;
        }
        MaybeSource src = this.source.getAndSet(null);
        if (src != null) {
            src.subscribe(this);
        }
    }

    @Override
    public void onSubscribe(Disposable d) {
    }

    @Override
    public void onSuccess(T value) {
        this.value = value;
        for (CacheDisposable inner : this.observers.getAndSet(TERMINATED)) {
            if (inner.isDisposed()) continue;
            inner.downstream.onSuccess(value);
        }
    }

    @Override
    public void onError(Throwable e) {
        this.error = e;
        for (CacheDisposable inner : this.observers.getAndSet(TERMINATED)) {
            if (inner.isDisposed()) continue;
            inner.downstream.onError(e);
        }
    }

    @Override
    public void onComplete() {
        for (CacheDisposable inner : this.observers.getAndSet(TERMINATED)) {
            if (inner.isDisposed()) continue;
            inner.downstream.onComplete();
        }
    }

    boolean add(CacheDisposable<T> inner) {
        CacheDisposable[] b;
        CacheDisposable<T>[] a;
        do {
            if ((a = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new CacheDisposable[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner;
        } while (!this.observers.compareAndSet(a, b));
        return true;
    }

    void remove(CacheDisposable<T> inner) {
        CacheDisposable[] b;
        CacheDisposable<T>[] a;
        do {
            int n;
            if ((n = (a = this.observers.get()).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != inner) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new CacheDisposable[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!this.observers.compareAndSet(a, b));
    }

    static final class CacheDisposable<T>
    extends AtomicReference<MaybeCache<T>>
    implements Disposable {
        private static final long serialVersionUID = -5791853038359966195L;
        final MaybeObserver<? super T> downstream;

        CacheDisposable(MaybeObserver<? super T> actual, MaybeCache<T> parent) {
            super(parent);
            this.downstream = actual;
        }

        @Override
        public void dispose() {
            MaybeCache mc = this.getAndSet(null);
            if (mc != null) {
                mc.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get() == null;
        }
    }
}

