/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.ResourceFile;
import jadx.api.ResourceFileContent;
import jadx.api.ResourceType;
import jadx.api.ResourcesLoader;
import jadx.core.codegen.CodeWriter;
import jadx.core.utils.Utils;
import jadx.core.xmlgen.ResContainer;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JLoadableNode;
import jadx.gui.treemodel.TextNode;
import jadx.gui.utils.NLS;
import jadx.gui.utils.OverlayIcon;
import jadx.gui.utils.UiUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public class JResource
extends JLoadableNode
implements Comparable<JResource> {
    private static final long serialVersionUID = -201018424302612434L;
    private static final ImageIcon ROOT_ICON = UiUtils.openIcon("cf_obj");
    private static final ImageIcon FOLDER_ICON = UiUtils.openIcon("folder");
    private static final ImageIcon FILE_ICON = UiUtils.openIcon("file_obj");
    private static final ImageIcon MANIFEST_ICON = UiUtils.openIcon("template_obj");
    private static final ImageIcon JAVA_ICON = UiUtils.openIcon("java_ovr");
    private static final ImageIcon ERROR_ICON = UiUtils.openIcon("error_co");
    private final transient String name;
    private final transient String shortName;
    private final transient List<JResource> files = new ArrayList<JResource>(1);
    private final transient JResType type;
    private final transient ResourceFile resFile;
    private transient boolean loaded;
    private transient String content;
    private transient Map<Integer, Integer> lineMapping = Collections.emptyMap();
    private static final Map<String, String> EXTENSION_TO_FILE_SYNTAX = Utils.newConstStringMap((String[])new String[]{"java", "text/java", "js", "text/javascript", "ts", "text/typescript", "json", "text/json", "css", "text/css", "less", "text/less", "html", "text/html", "xml", "text/xml", "yaml", "text/yaml", "properties", "text/properties", "ini", "text/ini", "sql", "text/sql", "arsc", "text/xml"});

    public JResource(ResourceFile resFile, String name, JResType type) {
        this(resFile, name, name, type);
    }

    public JResource(ResourceFile resFile, String name, String shortName, JResType type) {
        this.resFile = resFile;
        this.name = name;
        this.shortName = shortName;
        this.type = type;
        this.loaded = false;
    }

    public final void update() {
        if (this.files.isEmpty()) {
            if (this.type == JResType.DIR || this.type == JResType.ROOT || this.resFile.getType() == ResourceType.ARSC) {
                this.add(new TextNode(NLS.str("tree.loading", new Object[0])));
            }
        } else {
            this.removeAllChildren();
            Comparator typeComparator = (r1, r2) -> r1.type.ordinal() - r2.type.ordinal();
            Comparator<JResource> nameComparator = Comparator.comparing(JResource::getName, String.CASE_INSENSITIVE_ORDER);
            this.files.sort(typeComparator.thenComparing(nameComparator));
            for (JResource res : this.files) {
                res.update();
                this.add(res);
            }
        }
    }

    @Override
    public void loadNode() {
        this.getContent();
        this.update();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<JResource> getFiles() {
        return this.files;
    }

    @Override
    public synchronized String getContent() {
        if (this.loaded) {
            return this.content;
        }
        if (this.resFile == null || this.type != JResType.FILE) {
            return null;
        }
        if (!JResource.isSupportedForView(this.resFile.getType())) {
            return null;
        }
        ResContainer rc = this.resFile.loadContent();
        if (rc == null) {
            return null;
        }
        if (rc.getDataType() == ResContainer.DataType.RES_TABLE) {
            this.content = this.loadCurrentSingleRes(rc);
            for (ResContainer subFile : rc.getSubFiles()) {
                this.loadSubNodes(this, subFile, 1);
            }
            this.loaded = true;
            return this.content;
        }
        return this.loadCurrentSingleRes(rc);
    }

    private String loadCurrentSingleRes(ResContainer rc) {
        switch (rc.getDataType()) {
            case TEXT: 
            case RES_TABLE: {
                CodeWriter cw = rc.getText();
                this.lineMapping = cw.getLineMapping();
                return cw.toString();
            }
            case RES_LINK: {
                try {
                    return (String)ResourcesLoader.decodeStream((ResourceFile)rc.getResLink(), (size, is) -> {
                        if (size > 0xA00000L) {
                            return "File too large for view";
                        }
                        return ResourcesLoader.loadToCodeWriter((InputStream)is).toString();
                    });
                }
                catch (Exception e) {
                    return "Failed to load resource file: \n" + Utils.getStackTrace((Throwable)e);
                }
            }
        }
        return "Unexpected resource type: " + rc;
    }

    private void loadSubNodes(JResource root, ResContainer rc, int depth) {
        String resName = rc.getName();
        String[] path = resName.split("/");
        String resShortName = path.length == 0 ? resName : path[path.length - 1];
        CodeWriter cw = rc.getText();
        ResourceFileContent fileContent = new ResourceFileContent(resShortName, ResourceType.XML, cw);
        JResource.addPath(path, root, new JResource((ResourceFile)fileContent, resName, resShortName, JResType.FILE));
        for (ResContainer subFile : rc.getSubFiles()) {
            this.loadSubNodes(root, subFile, depth + 1);
        }
    }

    private static void addPath(String[] path, JResource root, JResource jResource) {
        if (path.length == 1) {
            root.getFiles().add(jResource);
            return;
        }
        JResource currentRoot = root;
        int last = path.length - 1;
        for (int i = 0; i <= last; ++i) {
            String f = path[i];
            if (i == last) {
                currentRoot.getFiles().add(jResource);
                continue;
            }
            currentRoot = JResource.getResDir(currentRoot, f);
        }
    }

    private static JResource getResDir(JResource root, String dirName) {
        for (JResource file : root.getFiles()) {
            if (!file.getName().equals(dirName)) continue;
            return file;
        }
        JResource resDir = new JResource(null, dirName, JResType.DIR);
        root.getFiles().add(resDir);
        return resDir;
    }

    @Override
    public Integer getSourceLine(int line) {
        if (this.lineMapping == null) {
            return null;
        }
        return this.lineMapping.get(line);
    }

    @Override
    public String getSyntaxName() {
        if (this.resFile == null) {
            return null;
        }
        switch (this.resFile.getType()) {
            case CODE: {
                return super.getSyntaxName();
            }
            case MANIFEST: 
            case XML: {
                return "text/xml";
            }
        }
        String syntax = this.getSyntaxByExtension(this.resFile.getName());
        if (syntax != null) {
            return syntax;
        }
        return super.getSyntaxName();
    }

    private String getSyntaxByExtension(String name) {
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        String ext = name.substring(dot + 1);
        return EXTENSION_TO_FILE_SYNTAX.get(ext);
    }

    @Override
    public Icon getIcon() {
        switch (this.type) {
            case ROOT: {
                return ROOT_ICON;
            }
            case DIR: {
                return FOLDER_ICON;
            }
            case FILE: {
                ResourceType resType = this.resFile.getType();
                if (resType == ResourceType.MANIFEST) {
                    return MANIFEST_ICON;
                }
                if (resType == ResourceType.CODE) {
                    return new OverlayIcon(FILE_ICON, ERROR_ICON, JAVA_ICON);
                }
                if (!JResource.isSupportedForView(resType)) {
                    return new OverlayIcon(FILE_ICON, ERROR_ICON);
                }
                return FILE_ICON;
            }
        }
        return FILE_ICON;
    }

    public static boolean isSupportedForView(ResourceType type) {
        switch (type) {
            case CODE: 
            case FONT: 
            case LIB: {
                return false;
            }
            case MANIFEST: 
            case XML: 
            case ARSC: 
            case IMG: 
            case UNKNOWN: {
                return true;
            }
        }
        return true;
    }

    public ResourceFile getResFile() {
        return this.resFile;
    }

    public Map<Integer, Integer> getLineMapping() {
        return this.lineMapping;
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    @Override
    public int compareTo(@NotNull JResource o) {
        return this.name.compareTo(o.name);
    }

    @Override
    public String makeString() {
        return this.shortName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.name.equals(((JResource)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static enum JResType {
        ROOT,
        DIR,
        FILE;

    }
}

