/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf;

import jadx.core.utils.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class NameMapper {
    private static final Pattern VALID_JAVA_IDENTIFIER = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private static final Pattern VALID_JAVA_FULL_IDENTIFIER = Pattern.compile("(" + VALID_JAVA_IDENTIFIER + "\\.)*" + VALID_JAVA_IDENTIFIER);
    private static final Set<String> RESERVED_NAMES = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"));

    public static boolean isReserved(String str) {
        return RESERVED_NAMES.contains(str);
    }

    public static boolean isValidIdentifier(String str) {
        return StringUtils.notEmpty(str) && !NameMapper.isReserved(str) && VALID_JAVA_IDENTIFIER.matcher(str).matches();
    }

    public static boolean isValidFullIdentifier(String str) {
        return StringUtils.notEmpty(str) && !NameMapper.isReserved(str) && VALID_JAVA_FULL_IDENTIFIER.matcher(str).matches();
    }

    public static boolean isValidAndPrintable(String str) {
        return NameMapper.isValidIdentifier(str) && NameMapper.isAllCharsPrintable(str);
    }

    public static boolean isValidIdentifierStart(int codePoint) {
        return Character.isJavaIdentifierStart(codePoint);
    }

    public static boolean isValidIdentifierPart(int codePoint) {
        return Character.isJavaIdentifierPart(codePoint);
    }

    public static boolean isPrintableChar(int c) {
        return 32 <= c && c <= 126;
    }

    public static boolean isAllCharsPrintable(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (NameMapper.isPrintableChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String removeInvalidCharsMiddle(String name) {
        if (NameMapper.isValidIdentifier(name) && NameMapper.isAllCharsPrintable(name)) {
            return name;
        }
        int len = name.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            int codePoint = name.codePointAt(i);
            if (!NameMapper.isPrintableChar(codePoint) || !NameMapper.isValidIdentifierPart(codePoint)) continue;
            sb.append((char)codePoint);
        }
        return sb.toString();
    }

    public static String removeInvalidChars(String name, String prefix) {
        int codePoint;
        String result = NameMapper.removeInvalidCharsMiddle(name);
        if (!result.isEmpty() && !NameMapper.isValidIdentifierStart(codePoint = result.codePointAt(0))) {
            return prefix + result;
        }
        return result;
    }

    private NameMapper() {
    }
}

