/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.classfile.Field;
import org.jd.core.v1.model.classfile.Method;
import org.jd.core.v1.model.classfile.attribute.AttributeExceptions;
import org.jd.core.v1.model.classfile.attribute.AttributeSignature;
import org.jd.core.v1.model.javasyntax.type.ArrayTypeArguments;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.BaseTypeParameter;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.model.javasyntax.type.TypeBounds;
import org.jd.core.v1.model.javasyntax.type.TypeParameter;
import org.jd.core.v1.model.javasyntax.type.TypeParameterWithTypeBounds;
import org.jd.core.v1.model.javasyntax.type.TypeParameters;
import org.jd.core.v1.model.javasyntax.type.Types;
import org.jd.core.v1.model.javasyntax.type.UnknownTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardSuperTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ObjectTypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.SignatureFormatException;
import org.jd.core.v1.util.DefaultList;

public class SignatureParser {
    protected static final UnknownTypeArgument UNKNOWN_TYPE_ARGUMENT = new UnknownTypeArgument();
    protected HashMap<String, MethodTypes> methodTypesCache = new HashMap(1024);
    protected HashMap<String, Type> typeCache = new HashMap(1024);
    protected ObjectTypeMaker objectTypeMaker;

    public SignatureParser(ObjectTypeMaker objectTypeMaker) {
        this.objectTypeMaker = objectTypeMaker;
        this.typeCache.put("B", PrimitiveType.TYPE_BYTE);
        this.typeCache.put("C", PrimitiveType.TYPE_CHAR);
        this.typeCache.put("D", PrimitiveType.TYPE_DOUBLE);
        this.typeCache.put("F", PrimitiveType.TYPE_FLOAT);
        this.typeCache.put("I", PrimitiveType.TYPE_INT);
        this.typeCache.put("J", PrimitiveType.TYPE_LONG);
        this.typeCache.put("S", PrimitiveType.TYPE_SHORT);
        this.typeCache.put("Z", PrimitiveType.TYPE_BOOLEAN);
        this.typeCache.put("java/lang/Class", ObjectType.TYPE_CLASS);
        this.typeCache.put("java/lang/Object", ObjectType.TYPE_OBJECT);
        this.typeCache.put("java/lang/String", ObjectType.TYPE_STRING);
    }

    public TypeTypes parseClassFileSignature(ClassFile classFile) {
        TypeTypes typeTypes = new TypeTypes();
        String internalTypeName = classFile.getInternalTypeName();
        typeTypes.thisType = this.objectTypeMaker.make(internalTypeName);
        AttributeSignature attributeSignature = (AttributeSignature)classFile.getAttribute("Signature");
        if (attributeSignature == null) {
            String superTypeName = classFile.getSuperTypeName();
            String[] interfaceTypeNames = classFile.getInterfaceTypeNames();
            if (!"java/lang/Object".equals(superTypeName)) {
                typeTypes.superType = this.objectTypeMaker.make(superTypeName);
            }
            if (interfaceTypeNames != null) {
                int length = interfaceTypeNames.length;
                if (length == 1) {
                    typeTypes.interfaces = this.objectTypeMaker.make(interfaceTypeNames[0]);
                } else {
                    Types list = new Types(length);
                    for (String interfaceTypeName : interfaceTypeNames) {
                        list.add(this.objectTypeMaker.make(interfaceTypeName));
                    }
                    typeTypes.interfaces = list;
                }
            }
        } else {
            SignatureReader reader = new SignatureReader(attributeSignature.getSignature());
            typeTypes.typeParameters = this.parseTypeParameters(reader);
            typeTypes.superType = this.parseClassTypeSignature(reader, 0);
            Type firstInterface = this.parseClassTypeSignature(reader, 0);
            if (firstInterface != null) {
                Type nextInterface = this.parseClassTypeSignature(reader, 0);
                if (nextInterface == null) {
                    typeTypes.interfaces = firstInterface;
                } else {
                    Types list = new Types(classFile.getInterfaceTypeNames().length);
                    list.add(firstInterface);
                    do {
                        list.add(nextInterface);
                    } while ((nextInterface = this.parseClassTypeSignature(reader, 0)) != null);
                    typeTypes.interfaces = list;
                }
            }
        }
        return typeTypes;
    }

    public MethodTypes parseConstructorSignature(Method method) {
        AttributeSignature attributeSignature = (AttributeSignature)method.getAttribute("Signature");
        if (attributeSignature == null) {
            return this.parseMethodSignature(method.getDescriptor(), method);
        }
        MethodTypes mt1 = this.parseMethodSignature(attributeSignature.getSignature(), method);
        MethodTypes mt2 = this.parseMethodSignature(method.getDescriptor(), method);
        if (mt1.parameters.size() == mt2.parameters.size()) {
            return mt1;
        }
        if (mt1.parameters.isEmpty() && mt1.typeParameters == null) {
            return mt2;
        }
        DefaultList<Type> parameters = new DefaultList<Type>((Collection<Type>)mt2.parameters);
        parameters.subList(1, 1 + mt1.parameters.size()).clear();
        parameters.addAll(1, mt1.parameters);
        MethodTypes mt3 = new MethodTypes();
        mt3.typeParameters = mt1.typeParameters;
        mt3.parameters = parameters;
        mt3.returned = mt1.returned;
        mt3.exceptions = mt1.exceptions;
        return mt3;
    }

    public MethodTypes parseMethodSignature(Method method) {
        AttributeSignature attributeSignature = (AttributeSignature)method.getAttribute("Signature");
        String signature = attributeSignature == null ? method.getDescriptor() : attributeSignature.getSignature();
        return this.parseMethodSignature(signature, method);
    }

    public Type parseFieldSignature(Field field) {
        AttributeSignature attributeSignature = (AttributeSignature)field.getAttribute("Signature");
        String signature = attributeSignature == null ? field.getDescriptor() : attributeSignature.getSignature();
        return this.parseTypeSignature(signature);
    }

    public Type parseTypeSignature(String signature) {
        Type type = this.typeCache.get(signature);
        if (type == null) {
            SignatureReader reader = new SignatureReader(signature);
            type = this.parseReferenceTypeSignature(reader);
            this.typeCache.put(signature, type);
        }
        return type;
    }

    public List<Type> parseParameterTypes(String signature) {
        MethodTypes methodTypes = this.parseMethodSignature(signature, null);
        return methodTypes == null ? Collections.emptyList() : methodTypes.parameters;
    }

    public Type parseReturnedType(String signature) {
        MethodTypes methodTypes = this.parseMethodSignature(signature, null);
        return methodTypes == null ? null : methodTypes.returned;
    }

    public static int countDimension(String descriptor) {
        int count = 0;
        int len = descriptor.length();
        for (int i = 0; i < len && descriptor.charAt(i) == '['; ++i) {
            ++count;
        }
        return count;
    }

    protected MethodTypes parseMethodSignature(String signature, Method method) {
        MethodTypes methodTypes = this.methodTypesCache.get(signature);
        if (methodTypes == null) {
            SignatureReader reader = new SignatureReader(signature);
            methodTypes = new MethodTypes();
            methodTypes.typeParameters = this.parseTypeParameters(reader);
            if (reader.read() != '(') {
                throw new SignatureFormatException(signature);
            }
            Type firstParameter = this.parseReferenceTypeSignature(reader);
            if (firstParameter == null) {
                methodTypes.parameters = Collections.emptyList();
            } else {
                Type nextParameter = this.parseReferenceTypeSignature(reader);
                if (nextParameter == null) {
                    methodTypes.parameters = Collections.singletonList(firstParameter);
                } else {
                    DefaultList<Type> list = new DefaultList<Type>();
                    list.add(firstParameter);
                    do {
                        list.add(nextParameter);
                    } while ((nextParameter = this.parseReferenceTypeSignature(reader)) != null);
                    methodTypes.parameters = list;
                }
            }
            if (reader.read() != ')') {
                throw new SignatureFormatException(signature);
            }
            methodTypes.returned = this.parseReferenceTypeSignature(reader);
            Type firstException = this.parseExceptionSignature(reader);
            if (firstException == null) {
                AttributeExceptions attributeExceptions;
                if (method != null && (attributeExceptions = (AttributeExceptions)method.getAttribute("Exceptions")) != null) {
                    String[] exceptionTypeNames = attributeExceptions.getExceptionTypeNames();
                    if (exceptionTypeNames.length == 1) {
                        methodTypes.exceptions = this.objectTypeMaker.make(exceptionTypeNames[0]);
                    } else {
                        Types list = new Types(exceptionTypeNames.length);
                        for (String exceptionTypeName : exceptionTypeNames) {
                            list.add(this.objectTypeMaker.make(exceptionTypeName));
                        }
                        methodTypes.exceptions = list;
                    }
                }
            } else {
                Type nextException = this.parseExceptionSignature(reader);
                if (nextException == null) {
                    methodTypes.exceptions = firstException;
                } else {
                    Types list = new Types();
                    list.add(firstException);
                    do {
                        list.add(nextException);
                    } while ((nextException = this.parseExceptionSignature(reader)) != null);
                    methodTypes.exceptions = list;
                }
            }
            this.methodTypesCache.put(signature, methodTypes);
        }
        return methodTypes;
    }

    protected BaseTypeParameter parseTypeParameters(SignatureReader reader) {
        if (reader.nextEqualsTo('<')) {
            BaseTypeParameter typeParameters;
            ++reader.index;
            TypeParameter firstTypeParameter = this.parseTypeParameter(reader);
            if (firstTypeParameter == null) {
                throw new SignatureFormatException(reader.signature);
            }
            TypeParameter nextTypeParameter = this.parseTypeParameter(reader);
            if (nextTypeParameter == null) {
                typeParameters = firstTypeParameter;
            } else {
                TypeParameters list = new TypeParameters();
                list.add(firstTypeParameter);
                do {
                    list.add(nextTypeParameter);
                } while ((nextTypeParameter = this.parseTypeParameter(reader)) != null);
                typeParameters = list;
            }
            if (reader.read() != '>') {
                throw new SignatureFormatException(reader.signature);
            }
            return typeParameters;
        }
        return null;
    }

    protected TypeParameter parseTypeParameter(SignatureReader reader) {
        int fistIndex = reader.index;
        if (reader.search(':')) {
            String identifier = reader.substring(fistIndex);
            Type firstBound = null;
            TypeBounds types = null;
            while (reader.nextEqualsTo(':')) {
                ++reader.index;
                Type bound = this.parseReferenceTypeSignature(reader);
                if (bound == null || bound.getDescriptor().equals("Ljava/lang/Object;")) continue;
                if (firstBound == null) {
                    firstBound = bound;
                    continue;
                }
                if (types == null) {
                    types = new TypeBounds();
                    types.add(firstBound);
                    types.add(bound);
                    continue;
                }
                types.add(bound);
            }
            if (firstBound == null) {
                return new TypeParameter(identifier);
            }
            if (types == null) {
                return new TypeParameterWithTypeBounds(identifier, firstBound);
            }
            return new TypeParameterWithTypeBounds(identifier, types);
        }
        return null;
    }

    protected Type parseExceptionSignature(SignatureReader reader) {
        if (reader.nextEqualsTo('^')) {
            ++reader.index;
            return this.parseReferenceTypeSignature(reader);
        }
        return null;
    }

    protected Type parseReferenceTypeSignature(SignatureReader reader) {
        if (reader.available()) {
            int dimension = 0;
            char c = reader.read();
            while (c == '[') {
                ++dimension;
                c = reader.read();
            }
            switch (c) {
                case 'B': {
                    return dimension == 0 ? PrimitiveType.TYPE_BYTE : PrimitiveType.TYPE_BYTE.createType(dimension);
                }
                case 'C': {
                    return dimension == 0 ? PrimitiveType.TYPE_CHAR : PrimitiveType.TYPE_CHAR.createType(dimension);
                }
                case 'D': {
                    return dimension == 0 ? PrimitiveType.TYPE_DOUBLE : PrimitiveType.TYPE_DOUBLE.createType(dimension);
                }
                case 'F': {
                    return dimension == 0 ? PrimitiveType.TYPE_FLOAT : PrimitiveType.TYPE_FLOAT.createType(dimension);
                }
                case 'I': {
                    return dimension == 0 ? PrimitiveType.TYPE_INT : PrimitiveType.TYPE_INT.createType(dimension);
                }
                case 'J': {
                    return dimension == 0 ? PrimitiveType.TYPE_LONG : PrimitiveType.TYPE_LONG.createType(dimension);
                }
                case 'L': {
                    --reader.index;
                    return this.parseClassTypeSignature(reader, dimension);
                }
                case 'S': {
                    return dimension == 0 ? PrimitiveType.TYPE_SHORT : PrimitiveType.TYPE_SHORT.createType(dimension);
                }
                case 'T': {
                    int index = reader.index++;
                    if (!reader.search(';')) {
                        return null;
                    }
                    String identifier = reader.substring(index);
                    return new GenericType(identifier, dimension);
                }
                case 'V': {
                    assert (dimension == 0);
                    return PrimitiveType.TYPE_VOID;
                }
                case 'Z': {
                    return dimension == 0 ? PrimitiveType.TYPE_BOOLEAN : PrimitiveType.TYPE_BOOLEAN.createType(dimension);
                }
            }
            --reader.index;
            return null;
        }
        return null;
    }

    protected boolean isAReferenceTypeSignature(SignatureReader reader) {
        if (reader.available()) {
            char c = reader.read();
            while (c == '[') {
                c = reader.read();
            }
            switch (c) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': {
                    return true;
                }
                case 'L': {
                    --reader.index;
                    return this.isAClassTypeSignature(reader);
                }
                case 'S': {
                    return true;
                }
                case 'T': {
                    reader.searchEndMarker();
                    return true;
                }
                case 'V': 
                case 'Z': {
                    return true;
                }
            }
            --reader.index;
            return false;
        }
        return false;
    }

    protected Type parseClassTypeSignature(SignatureReader reader, int dimension) {
        if (reader.nextEqualsTo('L')) {
            ++reader.index;
            int index = reader.index++;
            char endMarker = reader.searchEndMarker();
            if (endMarker == '\u0000') {
                throw new SignatureFormatException(reader.signature);
            }
            String internalTypeName = reader.substring(index);
            ObjectType ot = this.objectTypeMaker.make(internalTypeName);
            if (endMarker == '<') {
                ot = ot.createType(this.parseTypeArguments(reader));
                if (reader.read() != '>') {
                    throw new SignatureFormatException(reader.signature);
                }
            }
            while (reader.nextEqualsTo('.')) {
                String qualifiedName;
                index = ++reader.index;
                endMarker = reader.searchEndMarker();
                if (endMarker == '\u0000') {
                    throw new SignatureFormatException(reader.signature);
                }
                String name = reader.substring(index);
                internalTypeName = internalTypeName + '$' + name;
                if (Character.isDigit(name.charAt(0))) {
                    name = SignatureParser.extractLocalClassName(name);
                    qualifiedName = null;
                } else {
                    qualifiedName = ot.getQualifiedName() + '.' + name;
                }
                if (endMarker == '<') {
                    ++reader.index;
                    BaseTypeArgument typeArguments = this.parseTypeArguments(reader);
                    if (reader.read() != '>') {
                        throw new SignatureFormatException(reader.signature);
                    }
                    ot = new InnerObjectType(internalTypeName, qualifiedName, name, typeArguments, ot);
                    continue;
                }
                ot = new InnerObjectType(internalTypeName, qualifiedName, name, ot);
            }
            ++reader.index;
            return dimension == 0 ? ot : ot.createType(dimension);
        }
        return null;
    }

    protected boolean isAClassTypeSignature(SignatureReader reader) {
        if (reader.nextEqualsTo('L')) {
            ++reader.index;
            char endMarker = reader.searchEndMarker();
            if (endMarker == '\u0000') {
                throw new SignatureFormatException(reader.signature);
            }
            if (endMarker == '<') {
                ++reader.index;
                this.isATypeArguments(reader);
                if (reader.read() != '>') {
                    throw new SignatureFormatException(reader.signature);
                }
            }
            while (reader.nextEqualsTo('.')) {
                ++reader.index;
                endMarker = reader.searchEndMarker();
                if (endMarker == '\u0000') {
                    throw new SignatureFormatException(reader.signature);
                }
                if (endMarker != '<') continue;
                ++reader.index;
                this.isATypeArguments(reader);
                if (reader.read() == '>') continue;
                throw new SignatureFormatException(reader.signature);
            }
            ++reader.index;
            return true;
        }
        return false;
    }

    protected BaseTypeArgument parseTypeArguments(SignatureReader reader) {
        TypeArgument firstTypeArgument = this.parseTypeArgument(reader);
        if (firstTypeArgument == null) {
            throw new SignatureFormatException(reader.signature);
        }
        TypeArgument nextTypeArgument = this.parseTypeArgument(reader);
        if (nextTypeArgument == null) {
            return firstTypeArgument;
        }
        ArrayTypeArguments typeArguments = new ArrayTypeArguments();
        typeArguments.add(firstTypeArgument);
        do {
            typeArguments.add(nextTypeArgument);
        } while ((nextTypeArgument = this.parseTypeArgument(reader)) != null);
        return typeArguments;
    }

    protected boolean isATypeArguments(SignatureReader reader) {
        if (!this.isATypeArgument(reader)) {
            throw new SignatureFormatException(reader.signature);
        }
        while (this.isATypeArgument(reader)) {
        }
        return true;
    }

    protected TypeArgument parseTypeArgument(SignatureReader reader) {
        switch (reader.read()) {
            case '+': {
                return new WildcardExtendsTypeArgument(this.parseReferenceTypeSignature(reader));
            }
            case '-': {
                return new WildcardSuperTypeArgument(this.parseReferenceTypeSignature(reader));
            }
            case '*': {
                return UNKNOWN_TYPE_ARGUMENT;
            }
        }
        --reader.index;
        return this.parseReferenceTypeSignature(reader);
    }

    protected boolean isATypeArgument(SignatureReader reader) {
        switch (reader.read()) {
            case '+': 
            case '-': {
                return this.isAReferenceTypeSignature(reader);
            }
            case '*': {
                return true;
            }
        }
        --reader.index;
        return this.isAReferenceTypeSignature(reader);
    }

    protected static String extractLocalClassName(String name) {
        if (Character.isDigit(name.charAt(0))) {
            int i;
            int len = name.length();
            for (i = 0; i < len && Character.isDigit(name.charAt(i)); ++i) {
            }
            return i == len ? null : name.substring(i);
        }
        return name;
    }

    public static class MethodTypes {
        public BaseTypeParameter typeParameters;
        public List<Type> parameters;
        public Type returned;
        public BaseType exceptions;
    }

    public static class TypeTypes {
        public ObjectType thisType;
        public BaseTypeParameter typeParameters;
        public Type superType;
        public BaseType interfaces;
    }

    private static final class SignatureReader {
        public String signature;
        public char[] array;
        public int length;
        public int index = 0;

        public SignatureReader(String signature) {
            this(signature, 0);
        }

        public SignatureReader(String signature, int index) {
            this.signature = signature;
            this.array = signature.toCharArray();
            this.length = this.array.length;
            this.index = index;
        }

        public char read() {
            return this.array[this.index++];
        }

        public boolean nextEqualsTo(char c) {
            return this.index < this.length && this.array[this.index] == c;
        }

        public boolean search(char c) {
            int length = this.array.length;
            for (int i = this.index; i < length; ++i) {
                if (this.array[i] != c) continue;
                this.index = i;
                return true;
            }
            return false;
        }

        public char searchEndMarker() {
            int length = this.array.length;
            while (this.index < length) {
                char c = this.array[this.index];
                if (c == '<' || c == ';') {
                    return c;
                }
                ++this.index;
            }
            return '\u0000';
        }

        public boolean available() {
            return this.index < this.length;
        }

        public String substring(int beginIndex) {
            return new String(this.array, beginIndex, this.index - beginIndex);
        }

        public String toString() {
            return "SignatureReader{index=" + this.index + ", nextChars=" + new String(this.array, this.index, this.length - this.index) + "}";
        }
    }
}

