/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import org.jd.core.v1.model.javasyntax.type.AbstractNopTypeVisitor;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.PrimitiveTypeUtil;

public class GenerateParameterSuffixNameVisitor
extends AbstractNopTypeVisitor {
    protected String suffix;

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void visit(PrimitiveType type) {
        switch (PrimitiveTypeUtil.getStandardPrimitiveTypeFlags(type.getFlags())) {
            case 16: {
                this.suffix = "Byte";
                break;
            }
            case 2: {
                this.suffix = "Char";
                break;
            }
            case 8: {
                this.suffix = "Double";
                break;
            }
            case 4: {
                this.suffix = "Float";
                break;
            }
            case 64: {
                this.suffix = "Int";
                break;
            }
            case 128: {
                this.suffix = "Long";
                break;
            }
            case 32: {
                this.suffix = "Short";
                break;
            }
            case 1: {
                this.suffix = "Boolean";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public void visit(ObjectType type) {
        this.suffix = type.getName();
    }

    @Override
    public void visit(InnerObjectType type) {
        this.suffix = type.getName();
    }

    @Override
    public void visit(GenericType type) {
        this.suffix = type.getIdentifier();
    }
}

