/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class JIFunction
extends BaseFunction {
    private int arity;

    public JIFunction() {
    }

    public JIFunction(String name, int arity) {
        this.initNameArity(name, arity);
    }

    protected final void initNameArity(String name, int arity) {
        this.functionName = name;
        this.arity = arity;
    }

    public final void defineAsProperty(Scriptable scope) {
        this.defineAsProperty(scope, 2, false);
    }

    public final void defineAsProperty(Scriptable scope, int attributes) {
        this.defineAsProperty(scope, attributes, false);
    }

    public final void defineAsProperty(Scriptable scope, int attributes, boolean sealed) {
        this.setParentScope(scope);
        if (sealed) {
            this.sealObject();
        }
        ScriptableObject.defineProperty(scope, this.functionName, this, attributes);
    }

    @Override
    public Scriptable getPrototype() {
        Scriptable proto = super.getPrototype();
        if (proto == null) {
            proto = JIFunction.getFunctionPrototype(this.getParentScope());
            this.setPrototype(proto);
        }
        return proto;
    }

    @Override
    public abstract Object call(Context var1, Scriptable var2, Scriptable var3, Object[] var4) throws JavaScriptException;

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public int getLength() {
        return this.getArity();
    }
}

