/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.eventhubs.ErrorContext;
import com.microsoft.azure.eventhubs.impl.StringUtil;
import java.util.Locale;

public class EventHubException
extends Exception {
    private static final long serialVersionUID = -3654294093967132325L;
    private boolean isTransient;
    private ErrorContext errorContext;

    EventHubException(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public EventHubException(boolean isTransient, String message) {
        super(message);
        this.isTransient = isTransient;
    }

    public EventHubException(boolean isTransient, Throwable cause) {
        super(cause);
        this.isTransient = isTransient;
    }

    public EventHubException(boolean isTransient, String message, Throwable cause) {
        super(message, cause);
        this.isTransient = isTransient;
    }

    @Override
    public String getMessage() {
        String baseMessage = super.getMessage();
        return this.errorContext == null || StringUtil.isNullOrEmpty(this.errorContext.toString()) ? baseMessage : (!StringUtil.isNullOrEmpty(baseMessage) ? String.format(Locale.US, "%s, %s[%s]", baseMessage, "errorContext", this.errorContext.toString()) : String.format(Locale.US, "%s[%s]", "errorContext", this.errorContext.toString()));
    }

    public boolean getIsTransient() {
        return this.isTransient;
    }

    public ErrorContext getContext() {
        return this.errorContext;
    }

    public void setContext(ErrorContext errorContext) {
        this.errorContext = errorContext;
    }
}

