/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.AmqpLink;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseLinkHandler
extends BaseHandler {
    protected static final Logger TRACE_LOGGER = LoggerFactory.getLogger(BaseHandler.class);
    private final AmqpLink underlyingEntity;

    public BaseLinkHandler(AmqpLink amqpLink) {
        this.underlyingEntity = amqpLink;
    }

    public void onLinkLocalClose(Event event) {
        Link link = event.getLink();
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format("linkName[%s]", link.getName()));
        }
        this.closeSession(link);
    }

    public void onLinkRemoteClose(Event event) {
        this.handleRemoteLinkClosed(event);
    }

    public void onLinkRemoteDetach(Event event) {
        this.handleRemoteLinkClosed(event);
    }

    public void processOnClose(Link link, ErrorCondition condition) {
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info("linkName[" + link.getName() + (condition != null ? "], ErrorCondition[" + condition.getCondition() + ", " + condition.getDescription() + "]" : "], condition[null]"));
        }
        this.underlyingEntity.onClose(condition);
    }

    public void processOnClose(Link link, Exception exception) {
        this.underlyingEntity.onError(exception);
    }

    private void closeSession(Link link) {
        if (link.getSession() != null && link.getSession().getLocalState() != EndpointState.CLOSED) {
            link.getSession().close();
        }
    }

    private void handleRemoteLinkClosed(Event event) {
        Link link = event.getLink();
        if (link.getLocalState() != EndpointState.CLOSED) {
            link.close();
        }
        ErrorCondition condition = link.getRemoteCondition();
        this.processOnClose(link, condition);
        this.closeSession(link);
    }
}

