/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.stringio.StringIO;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.msgpack.jruby.Decoder;
import org.msgpack.jruby.ExtensionRegistry;

@JRubyClass(name={"MessagePack::Unpacker"})
public class Unpacker
extends RubyObject {
    private final ExtensionRegistry registry;
    private IRubyObject stream;
    private IRubyObject data;
    private Decoder decoder;
    private final RubyClass underflowErrorClass;
    private boolean symbolizeKeys;
    private boolean allowUnknownExt;

    public Unpacker(Ruby ruby, RubyClass rubyClass) {
        this(ruby, rubyClass, new ExtensionRegistry());
    }

    public Unpacker(Ruby ruby, RubyClass rubyClass, ExtensionRegistry extensionRegistry) {
        super(ruby, rubyClass);
        this.registry = extensionRegistry;
        this.underflowErrorClass = ruby.getModule("MessagePack").getClass("UnderflowError");
    }

    @JRubyMethod(name={"initialize"}, optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        this.symbolizeKeys = false;
        this.allowUnknownExt = false;
        if (iRubyObjectArray.length > 0) {
            if (iRubyObjectArray[iRubyObjectArray.length - 1] instanceof RubyHash) {
                IRubyObject iRubyObject;
                RubyHash rubyHash = (RubyHash)iRubyObjectArray[iRubyObjectArray.length - 1];
                IRubyObject iRubyObject2 = rubyHash.fastARef((IRubyObject)threadContext.getRuntime().newSymbol("symbolize_keys"));
                if (iRubyObject2 != null) {
                    this.symbolizeKeys = iRubyObject2.isTrue();
                }
                if ((iRubyObject = rubyHash.fastARef((IRubyObject)threadContext.getRuntime().newSymbol("allow_unknown_ext"))) != null) {
                    this.allowUnknownExt = iRubyObject.isTrue();
                }
            }
            if (iRubyObjectArray[0] != threadContext.getRuntime().getNil() && !(iRubyObjectArray[0] instanceof RubyHash)) {
                this.setStream(threadContext, iRubyObjectArray[0]);
            }
        }
        return this;
    }

    public static Unpacker newUnpacker(ThreadContext threadContext, ExtensionRegistry extensionRegistry, IRubyObject[] iRubyObjectArray) {
        Unpacker unpacker = new Unpacker(threadContext.getRuntime(), threadContext.getRuntime().getModule("MessagePack").getClass("Unpacker"), extensionRegistry);
        unpacker.initialize(threadContext, iRubyObjectArray);
        return unpacker;
    }

    @JRubyMethod(name={"symbolize_keys?"})
    public IRubyObject isSymbolizeKeys(ThreadContext threadContext) {
        return this.symbolizeKeys ? threadContext.getRuntime().getTrue() : threadContext.getRuntime().getFalse();
    }

    @JRubyMethod(name={"allow_unknown_ext?"})
    public IRubyObject isAllowUnknownExt(ThreadContext threadContext) {
        return this.allowUnknownExt ? threadContext.getRuntime().getTrue() : threadContext.getRuntime().getFalse();
    }

    @JRubyMethod(name={"registered_types_internal"}, visibility=Visibility.PRIVATE)
    public IRubyObject registeredTypesInternal(ThreadContext threadContext) {
        return this.registry.toInternalUnpackerRegistry(threadContext);
    }

    @JRubyMethod(name={"register_type"}, required=1, optional=2)
    public IRubyObject registerType(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        RubyModule rubyModule;
        RubyProc rubyProc;
        RubyProc rubyProc2;
        Ruby ruby = threadContext.getRuntime();
        IRubyObject iRubyObject = iRubyObjectArray[0];
        if (iRubyObjectArray.length == 1) {
            if (!block.isGiven()) {
                throw ruby.newLocalJumpErrorNoBlock();
            }
            rubyProc2 = RubyProc.newProc((Ruby)ruby, (Block)block, (Block.Type)block.type);
            if (rubyProc2 == null) {
                System.err.println("proc from Block is null");
            }
            rubyProc = rubyProc2;
            rubyModule = null;
        } else if (iRubyObjectArray.length == 3) {
            rubyModule = (RubyModule)iRubyObjectArray[1];
            rubyProc = iRubyObjectArray[2];
            rubyProc2 = rubyModule.method((IRubyObject)rubyProc);
        } else {
            throw ruby.newArgumentError(String.format("wrong number of arguments (%d for 1 or 3)", 2 + iRubyObjectArray.length));
        }
        long l = ((RubyFixnum)iRubyObject).getLongValue();
        if (l < -128L || l > 127L) {
            throw ruby.newRangeError(String.format("integer %d too big to convert to `signed char'", l));
        }
        this.registry.put(rubyModule, (int)l, null, null, (IRubyObject)rubyProc2, (IRubyObject)rubyProc);
        return ruby.getNil();
    }

    @JRubyMethod(required=2)
    public IRubyObject execute(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.executeLimit(threadContext, iRubyObject, iRubyObject2, null);
    }

    @JRubyMethod(name={"execute_limit"}, required=3)
    public IRubyObject executeLimit(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Decoder decoder;
        block3: {
            RubyString rubyString = iRubyObject.asString();
            int n = RubyNumeric.fix2int((IRubyObject)iRubyObject2);
            int n2 = iRubyObject3 == null || iRubyObject3.isNil() ? -1 : RubyNumeric.fix2int((IRubyObject)iRubyObject3);
            ByteList byteList = rubyString.getByteList();
            if (n2 == -1) {
                n2 = byteList.length() - n;
            }
            decoder = new Decoder(threadContext.getRuntime(), this.registry, byteList.unsafeBytes(), byteList.begin() + n, n2, this.symbolizeKeys, this.allowUnknownExt);
            try {
                this.data = null;
                this.data = decoder.next();
            }
            catch (RaiseException raiseException) {
                if (raiseException.getException().getType() == this.underflowErrorClass) break block3;
                throw raiseException;
            }
        }
        return threadContext.getRuntime().newFixnum(decoder.offset());
    }

    @JRubyMethod(name={"data"})
    public IRubyObject getData(ThreadContext threadContext) {
        if (this.data == null) {
            return threadContext.getRuntime().getNil();
        }
        return this.data;
    }

    @JRubyMethod(name={"finished?"})
    public IRubyObject finished_p(ThreadContext threadContext) {
        return this.data == null ? threadContext.getRuntime().getFalse() : threadContext.getRuntime().getTrue();
    }

    @JRubyMethod(required=1)
    public IRubyObject feed(ThreadContext threadContext, IRubyObject iRubyObject) {
        ByteList byteList = iRubyObject.asString().getByteList();
        if (this.decoder == null) {
            this.decoder = new Decoder(threadContext.getRuntime(), this.registry, byteList.unsafeBytes(), byteList.begin(), byteList.length(), this.symbolizeKeys, this.allowUnknownExt);
        } else {
            this.decoder.feed(byteList.unsafeBytes(), byteList.begin(), byteList.length());
        }
        return this;
    }

    @JRubyMethod(name={"full_unpack"})
    public IRubyObject fullUnpack(ThreadContext threadContext) {
        return this.decoder.next();
    }

    @JRubyMethod(name={"feed_each"}, required=1)
    public IRubyObject feedEach(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        this.feed(threadContext, iRubyObject);
        if (block.isGiven()) {
            this.each(threadContext, block);
            return threadContext.getRuntime().getNil();
        }
        return this.callMethod(threadContext, "to_enum");
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext threadContext, Block block) {
        if (block.isGiven()) {
            block5: {
                if (this.decoder != null) {
                    try {
                        while (this.decoder.hasNext()) {
                            block.yield(threadContext, this.decoder.next());
                        }
                    }
                    catch (RaiseException raiseException) {
                        if (raiseException.getException().getType() == this.underflowErrorClass) break block5;
                        throw raiseException;
                    }
                }
            }
            return this;
        }
        return this.callMethod(threadContext, "to_enum");
    }

    @JRubyMethod
    public IRubyObject fill(ThreadContext threadContext) {
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject reset(ThreadContext threadContext) {
        if (this.decoder != null) {
            this.decoder.reset();
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"read"}, alias={"unpack"})
    public IRubyObject read(ThreadContext threadContext) {
        if (this.decoder == null) {
            throw threadContext.getRuntime().newEOFError();
        }
        try {
            return this.decoder.next();
        }
        catch (RaiseException raiseException) {
            if (raiseException.getException().getType() != this.underflowErrorClass) {
                throw raiseException;
            }
            throw threadContext.getRuntime().newEOFError();
        }
    }

    @JRubyMethod(name={"skip"})
    public IRubyObject skip(ThreadContext threadContext) {
        throw threadContext.getRuntime().newNotImplementedError("Not supported yet in JRuby implementation");
    }

    @JRubyMethod(name={"skip_nil"})
    public IRubyObject skipNil(ThreadContext threadContext) {
        throw threadContext.getRuntime().newNotImplementedError("Not supported yet in JRuby implementation");
    }

    @JRubyMethod
    public IRubyObject read_array_header(ThreadContext threadContext) {
        if (this.decoder != null) {
            try {
                return this.decoder.read_array_header();
            }
            catch (RaiseException raiseException) {
                if (raiseException.getException().getType() != this.underflowErrorClass) {
                    throw raiseException;
                }
                throw threadContext.getRuntime().newEOFError();
            }
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject read_map_header(ThreadContext threadContext) {
        if (this.decoder != null) {
            try {
                return this.decoder.read_map_header();
            }
            catch (RaiseException raiseException) {
                if (raiseException.getException().getType() != this.underflowErrorClass) {
                    throw raiseException;
                }
                throw threadContext.getRuntime().newEOFError();
            }
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"stream"})
    public IRubyObject getStream(ThreadContext threadContext) {
        if (this.stream == null) {
            return threadContext.getRuntime().getNil();
        }
        return this.stream;
    }

    @JRubyMethod(name={"stream="}, required=1)
    public IRubyObject setStream(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyString rubyString;
        if (iRubyObject instanceof StringIO) {
            rubyString = iRubyObject.callMethod(threadContext, "string").asString();
        } else if (iRubyObject instanceof RubyIO) {
            rubyString = iRubyObject.callMethod(threadContext, "read").asString();
        } else if (iRubyObject.respondsTo("read")) {
            rubyString = iRubyObject.callMethod(threadContext, "read").asString();
        } else {
            throw threadContext.getRuntime().newTypeError(iRubyObject, "IO");
        }
        ByteList byteList = rubyString.getByteList();
        this.stream = iRubyObject;
        this.decoder = null;
        this.decoder = new Decoder(threadContext.getRuntime(), this.registry, byteList.unsafeBytes(), byteList.begin(), byteList.length(), this.symbolizeKeys, this.allowUnknownExt);
        return this.getStream(threadContext);
    }

    static class UnpackerAllocator
    implements ObjectAllocator {
        UnpackerAllocator() {
        }

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new Unpacker(ruby, rubyClass);
        }
    }
}

