/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.logstash.common.IncompleteSourceWithMetadataException;
import org.logstash.config.ir.HashableWithSource;

public class SourceWithMetadata
implements HashableWithSource {
    private final String protocol;
    private final String id;
    private final Integer line;
    private final Integer column;
    private final String text;
    private static final Pattern emptyString = Pattern.compile("^\\s*$");

    public String getProtocol() {
        return this.protocol;
    }

    public String getId() {
        return this.id;
    }

    public Integer getLine() {
        return this.line;
    }

    public Integer getColumn() {
        return this.column;
    }

    public String getText() {
        return this.text;
    }

    public SourceWithMetadata(String protocol, String id, Integer line, Integer column, String text) throws IncompleteSourceWithMetadataException {
        this.protocol = protocol;
        this.id = id;
        this.line = line;
        this.column = column;
        this.text = text;
        List badAttributes = this.attributes().stream().filter(a -> {
            if (a == null) {
                return true;
            }
            if (a instanceof String) {
                return emptyString.matcher((String)a).matches();
            }
            return false;
        }).collect(Collectors.toList());
        if (!(this.getText() instanceof String)) {
            badAttributes.add(this.getText());
        }
        if (!badAttributes.isEmpty()) {
            String message = "Missing attributes in SourceWithMetadata: (" + badAttributes + ") " + this.toString();
            throw new IncompleteSourceWithMetadataException(message);
        }
    }

    public SourceWithMetadata(String protocol, String id, String text) throws IncompleteSourceWithMetadataException {
        this(protocol, id, 0, 0, text);
    }

    public int hashCode() {
        return Objects.hash(this.hashableAttributes().toArray());
    }

    public String toString() {
        return "[" + this.protocol + "]" + this.id + ":" + this.line + ":" + this.column + ":```\n" + this.text + "\n```";
    }

    @Override
    public String hashSource() {
        return this.hashableAttributes().stream().map(Object::toString).collect(Collectors.joining("|"));
    }

    private Collection<Object> attributes() {
        return Arrays.asList(this.getId(), this.getProtocol(), this.getLine(), this.getColumn());
    }

    private Collection<Object> hashableAttributes() {
        return Arrays.asList(this.getId(), this.getProtocol(), this.getLine(), this.getColumn(), this.getText());
    }
}

