/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.logstash.common.SourceWithMetadata;
import org.logstash.common.Util;
import org.logstash.config.ir.HashableWithSource;
import org.logstash.config.ir.InvalidIRException;
import org.logstash.config.ir.SourceComponent;
import org.logstash.config.ir.graph.Edge;
import org.logstash.config.ir.graph.Graph;
import org.logstash.config.ir.graph.PlainEdge;
import org.logstash.config.ir.graph.algorithms.DepthFirst;

public abstract class Vertex
implements SourceComponent,
HashableWithSource {
    private static final AtomicInteger SEQUENCE = new AtomicInteger();
    private final int hashCode = SEQUENCE.incrementAndGet();
    private final String explicitId;
    private final SourceWithMetadata meta;
    private Graph graph;
    private volatile String contextualHashCache;
    private volatile String hashCache;
    private volatile String individualHashSourceCache;
    private volatile String generatedId;

    protected Vertex(SourceWithMetadata meta) {
        this(meta, null);
    }

    protected Vertex(SourceWithMetadata meta, String explicitId) {
        if (meta == null) {
            throw new IllegalArgumentException("No source with metadata declared for " + this.getClass().getName());
        }
        this.meta = meta;
        this.explicitId = explicitId;
    }

    public abstract Vertex copy();

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object other) {
        return this == other;
    }

    public final Graph getGraph() {
        return this.graph;
    }

    public final void setGraph(Graph graph) {
        if (this.graph == graph) {
            return;
        }
        if (this.graph != null) {
            throw new IllegalArgumentException("Cannot set graph property on Vertex that is already assigned to an existing graph!");
        }
        this.graph = graph;
    }

    public boolean isRoot() {
        return this.getIncomingEdges().isEmpty();
    }

    public boolean isLeaf() {
        return this.getOutgoingEdges().isEmpty();
    }

    public boolean hasIncomingEdges() {
        return !this.getIncomingEdges().isEmpty();
    }

    public boolean hasOutgoingEdges() {
        return !this.getOutgoingEdges().isEmpty();
    }

    public Collection<Edge> getIncomingEdges() {
        return this.incomingEdges().collect(Collectors.toSet());
    }

    public Collection<Edge> getOutgoingEdges() {
        return this.outgoingEdges().collect(Collectors.toSet());
    }

    public Collection<Vertex> getOutgoingVertices() {
        return this.outgoingVertices().collect(Collectors.toList());
    }

    public Stream<Vertex> outgoingVertices() {
        return this.outgoingEdges().map(Edge::getTo);
    }

    public Collection<Vertex> getIncomingVertices() {
        return this.incomingVertices().collect(Collectors.toList());
    }

    public Stream<Vertex> incomingVertices() {
        return this.incomingEdges().map(Edge::getFrom);
    }

    public Stream<Edge> incomingEdges() {
        return this.graph.getIncomingEdges(this).stream();
    }

    public Stream<Edge> outgoingEdges() {
        return this.graph.getOutgoingEdges(this).stream();
    }

    public Stream<Vertex> ancestors() {
        return DepthFirst.reverseDepthFirst(this).filter(v -> v != this);
    }

    public Stream<Vertex> roots() {
        return this.ancestors().filter(Vertex::isRoot);
    }

    public Stream<Vertex> descendants() {
        return DepthFirst.depthFirst(this).filter(v -> v != this);
    }

    public Stream<Vertex> lineage() {
        return Stream.concat(Stream.concat(this.ancestors(), Stream.of(this)), this.descendants());
    }

    public int rank() {
        return this.graph.rank(this);
    }

    @Override
    public String uniqueHash() {
        if (this.hashCache != null) {
            return this.hashCache;
        }
        if (this.getSourceWithMetadata() != null) {
            return this.getSourceWithMetadata().uniqueHash();
        }
        throw new RuntimeException("Attempted to compute unique hash on a vertex with no source metadata!");
    }

    @Override
    public String hashSource() {
        return this.uniqueHash();
    }

    public Collection<Edge.EdgeFactory> getUnusedOutgoingEdgeFactories() {
        if (!this.hasOutgoingEdges()) {
            return Collections.singletonList(PlainEdge.factory);
        }
        return Collections.emptyList();
    }

    public boolean isPartialLeaf() {
        return this.getUnusedOutgoingEdgeFactories().size() > 0;
    }

    public boolean acceptsOutgoingEdge(Edge e) {
        return true;
    }

    public String getExplicitId() {
        return this.explicitId;
    }

    public String getId() {
        if (this.explicitId != null) {
            return this.explicitId;
        }
        if (this.generatedId != null) {
            return this.generatedId;
        }
        if (this.getGraph() == null) {
            throw new RuntimeException("Attempted to get ID from PluginVertex before attaching it to a graph!");
        }
        this.generatedId = this.getSourceWithMetadata() != null ? Util.digest(this.graph.uniqueHash() + "|" + this.getSourceWithMetadata().uniqueHash()) : this.uniqueHash();
        return this.generatedId;
    }

    public void clearCache() {
        this.hashCache = null;
        this.contextualHashCache = null;
        this.individualHashSourceCache = null;
    }

    @Override
    public SourceWithMetadata getSourceWithMetadata() {
        return this.meta;
    }

    public static class InvalidEdgeTypeException
    extends InvalidIRException {
        private static final long serialVersionUID = -2707379453144995223L;

        public InvalidEdgeTypeException(String s) {
            super(s);
        }
    }
}

