/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ext;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.ackedqueue.AckedReadBatch;
import org.logstash.ackedqueue.ext.JRubyAckedQueueExt;
import org.logstash.execution.QueueBatch;
import org.logstash.execution.QueueReadClient;
import org.logstash.execution.QueueReadClientBase;

@JRubyClass(name={"AckedReadClient"}, parent="QueueReadClientBase")
public final class JrubyAckedReadClientExt
extends QueueReadClientBase
implements QueueReadClient {
    private JRubyAckedQueueExt queue;

    @JRubyMethod(meta=true, required=1)
    public static JrubyAckedReadClientExt create(ThreadContext context, IRubyObject recv, IRubyObject queue) {
        return new JrubyAckedReadClientExt(context.runtime, RubyUtil.ACKED_READ_CLIENT_CLASS, queue);
    }

    public static JrubyAckedReadClientExt create(IRubyObject queue) {
        return new JrubyAckedReadClientExt(RubyUtil.RUBY, RubyUtil.ACKED_READ_CLIENT_CLASS, queue);
    }

    public JrubyAckedReadClientExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    private JrubyAckedReadClientExt(Ruby runtime, RubyClass metaClass, IRubyObject queue) {
        super(runtime, metaClass);
        this.queue = (JRubyAckedQueueExt)queue;
    }

    @Override
    public void close() throws IOException {
        this.queue.close();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public QueueBatch newBatch() {
        return AckedReadBatch.create(this.queue, 0, 0L);
    }

    @Override
    public QueueBatch readBatch() {
        AckedReadBatch batch = AckedReadBatch.create(this.queue, this.batchSize, this.waitForMillis);
        this.startMetrics(batch);
        return batch;
    }
}

