/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.secret.store;

import org.logstash.secret.SecretIdentifier;

public class SecretStoreException
extends RuntimeException {
    private SecretStoreException(String message, Throwable cause) {
        super(message, cause);
    }

    private SecretStoreException(String message) {
        super(message);
    }

    public static class InvalidConfigurationException
    extends SecretStoreException {
        public InvalidConfigurationException(String message) {
            super(message);
        }
    }

    public static class AlreadyExistsException
    extends SecretStoreException {
        public AlreadyExistsException(String message) {
            super(message);
        }
    }

    public static class AccessException
    extends SecretStoreException {
        public AccessException(String message, Throwable throwable) {
            super(message, throwable);
        }

        public AccessException(String message) {
            super(message);
        }
    }

    public static class ImplementationNotFoundException
    extends SecretStoreException {
        public ImplementationNotFoundException(String message, Throwable throwable) {
            super(message, throwable);
        }
    }

    public static class UnknownException
    extends SecretStoreException {
        public UnknownException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class PurgeException
    extends SecretStoreException {
        public PurgeException(SecretIdentifier secretIdentifier, Throwable cause) {
            super(String.format("Error while trying to purge secret %s", secretIdentifier.toExternalForm()), cause);
        }
    }

    public static class PersistException
    extends SecretStoreException {
        public PersistException(SecretIdentifier secretIdentifier, Throwable cause) {
            super(String.format("Error while trying to store secret %s", secretIdentifier.toExternalForm()), cause);
        }
    }

    public static class LoadException
    extends SecretStoreException {
        public LoadException(String message, Throwable cause) {
            super(message, cause);
        }

        public LoadException(String message) {
            super(message);
        }
    }

    public static class CreateException
    extends SecretStoreException {
        public CreateException(String message, Throwable cause) {
            super(message, cause);
        }

        public CreateException(String message) {
            super(message);
        }
    }

    public static class ListException
    extends SecretStoreException {
        public ListException(Throwable cause) {
            super("Error while trying to list keys in secret store", cause);
        }
    }

    public static class RetrievalException
    extends SecretStoreException {
        public RetrievalException(SecretIdentifier secretIdentifier, Throwable cause) {
            super(String.format("Error while trying to retrieve secret %s", secretIdentifier.toExternalForm()), cause);
        }
    }
}

