/*
 * Decompiled with CFR 0.152.
 */
package http_parser.lolevel;

import http_parser.HTTPMethod;
import http_parser.ParserType;
import http_parser.lolevel.Message;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLoaderNG {
    String fn;
    static final byte BSLASH = 92;
    static final byte QUOT = 34;
    static final byte CR = 13;
    static final byte LF = 10;
    static final byte n = 110;
    static final byte r = 114;
    static final Byte[] JAVA_GENERICS_ROCK_HARD = new Byte[0];

    public TestLoaderNG(String string) {
        this.fn = string;
    }

    static void p(Object object) {
        System.out.println(object);
    }

    public static List<Message> load(String string) {
        List<Message> list = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            list = TestLoaderNG.load(bufferedReader);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return list;
    }

    public static Message parse(String string) {
        List<Message> list = TestLoaderNG.load(new BufferedReader(new StringReader(string)));
        if (null == list || 0 == list.size()) {
            return null;
        }
        return list.get(0);
    }

    public static List<Message> load(BufferedReader bufferedReader) {
        LinkedList<Message> linkedList = new LinkedList<Message>();
        String string = null;
        Message message = new Message();
        Pattern pattern = Pattern.compile("(\\S+)\\s*:(.*)");
        try {
            while (null != (string = bufferedReader.readLine())) {
                if ("".equals(string.trim())) {
                    linkedList.add(message);
                    message = new Message();
                    continue;
                }
                Matcher matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    MatchResult matchResult = matcher.toMatchResult();
                    String string2 = matchResult.group(1).trim();
                    String string3 = matchResult.group(2).trim();
                    if ("name".equals(string2)) {
                        message.name = string3;
                        continue;
                    }
                    if ("raw".equals(string2)) {
                        message.raw = TestLoaderNG.toByteArray(string3);
                        continue;
                    }
                    if ("type".equals(string2)) {
                        message.type = ParserType.parse(string3);
                        continue;
                    }
                    if ("method".equals(string2)) {
                        message.method = HTTPMethod.parse(string3);
                        continue;
                    }
                    if ("status_code".equals(string2)) {
                        message.status_code = Integer.parseInt(string3);
                        continue;
                    }
                    if ("request_path".equals(string2)) {
                        message.request_path = string3;
                        continue;
                    }
                    if ("request_url".equals(string2)) {
                        message.request_url = string3;
                        continue;
                    }
                    if ("fragment".equals(string2)) {
                        message.fragment = string3;
                        continue;
                    }
                    if ("query_string".equals(string2)) {
                        message.query_string = string3;
                        continue;
                    }
                    if ("body".equals(string2)) {
                        message.body = TestLoaderNG.toByteArray(string3);
                        continue;
                    }
                    if ("body_size".equals(string2)) {
                        message.body_size = Integer.parseInt(string3);
                        continue;
                    }
                    if (string2.startsWith("header")) {
                        String[] stringArray = TestLoaderNG.getHeader(string3);
                        message.header.put(stringArray[0], stringArray[1]);
                        continue;
                    }
                    if ("should_keep_alive".equals(string2)) {
                        message.should_keep_alive = 1 == Integer.parseInt(string3);
                        continue;
                    }
                    if ("upgrade".equals(string2)) {
                        message.upgrade = TestLoaderNG.toByteArray(string3);
                        continue;
                    }
                    if ("http_major".equals(string2)) {
                        message.http_major = Integer.parseInt(string3);
                        continue;
                    }
                    if (!"http_minor".equals(string2)) continue;
                    message.http_minor = Integer.parseInt(string3);
                    continue;
                }
                TestLoaderNG.p("WTF?" + string);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return linkedList;
    }

    static String[] getHeader(String string) {
        Pattern pattern = Pattern.compile("\\{ ?\"([^\"]*)\": ?\"(.*)\"}");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            TestLoaderNG.p(string);
            throw new RuntimeException("something wrong");
        }
        String[] stringArray = new String[2];
        MatchResult matchResult = matcher.toMatchResult();
        stringArray[0] = matchResult.group(1).trim();
        stringArray[1] = matchResult.group(2);
        return stringArray;
    }

    static byte[] toByteArray(String string) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        String string2 = string.substring(1, string.length() - 1);
        byte[] byArray = string2.getBytes(Charset.forName("UTF8"));
        boolean bl = false;
        block6: for (byte by : byArray) {
            switch (by) {
                case 92: {
                    bl = true;
                    continue block6;
                }
                case 110: {
                    if (bl) {
                        arrayList.add((byte)10);
                        bl = false;
                        continue block6;
                    }
                    arrayList.add(by);
                    continue block6;
                }
                case 114: {
                    if (bl) {
                        bl = false;
                        arrayList.add((byte)13);
                        continue block6;
                    }
                    arrayList.add(by);
                    continue block6;
                }
                case 34: {
                    bl = false;
                    arrayList.add((byte)34);
                    continue block6;
                }
                default: {
                    arrayList.add(by);
                }
            }
        }
        byArray = new byte[arrayList.size()];
        int n = 0;
        for (Byte by : arrayList) {
            byArray[n++] = by;
        }
        return byArray;
    }

    public static void main(String[] stringArray) throws Throwable {
        List<Message> list = TestLoaderNG.load(stringArray[0]);
        for (Message message : list) {
            message.execute_permutations();
            message.execute();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LastHeader {
        NONE,
        FIELD,
        VALUE;

    }

    class Header {
        String field;
        String value;

        Header() {
        }
    }
}

