/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.impl.DefaultWebContext;

public class DefaultWebContextBuilder
implements WebContextFactory.WebContextBuilder {
    private static ThreadLocal<ArrayList<WebContext>> contextStack = new ThreadLocal();
    private static final Log log = LogFactory.getLog(DefaultWebContextBuilder.class);

    @Override
    public WebContext get() {
        ArrayList<WebContext> stack = contextStack.get();
        if (stack == null || stack.size() == 0) {
            return null;
        }
        return stack.get(stack.size() - 1);
    }

    @Override
    public void engageThread(Container container, HttpServletRequest request, HttpServletResponse response) {
        try {
            ServletConfig servletConfig = container.getBean(ServletConfig.class);
            ServletContext servletContext = container.getBean(ServletContext.class);
            DefaultWebContext ec = new DefaultWebContext(container, request, response, servletConfig, servletContext);
            this.engageThread(ec);
        }
        catch (Exception ex) {
            log.fatal((Object)"Failed to create an ExecutionContext", (Throwable)ex);
        }
    }

    @Override
    public void engageThread(WebContext webContext) {
        ArrayList<WebContext> stack = contextStack.get();
        if (stack == null) {
            stack = new ArrayList();
            contextStack.set(stack);
        }
        stack.add(webContext);
    }

    @Override
    public void disengageThread() {
        ArrayList<WebContext> stack;
        if (contextStack != null && (stack = contextStack.get()) != null) {
            if (stack.size() > 0) {
                stack.remove(stack.size() - 1);
            }
            if (stack.size() == 0) {
                contextStack.set(null);
            }
        }
    }
}

