/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.search.uhighlight.PhraseHelper;
import org.apache.lucene.search.uhighlight.UHComponents;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;

public abstract class FieldOffsetStrategy {
    protected final UHComponents components;

    public FieldOffsetStrategy(UHComponents components) {
        this.components = components;
    }

    public String getField() {
        return this.components.getField();
    }

    public abstract UnifiedHighlighter.OffsetSource getOffsetSource();

    public abstract OffsetsEnum getOffsetsEnum(LeafReader var1, int var2, String var3) throws IOException;

    protected OffsetsEnum createOffsetsEnumFromReader(LeafReader leafReader, int doc) throws IOException {
        Terms termsIndex = leafReader.terms(this.getField());
        if (termsIndex == null) {
            return OffsetsEnum.EMPTY;
        }
        ArrayList<OffsetsEnum> offsetsEnums = new ArrayList<OffsetsEnum>();
        if (this.components.getHighlightFlags().contains((Object)UnifiedHighlighter.HighlightFlag.WEIGHT_MATCHES)) {
            this.createOffsetsEnumsWeightMatcher(leafReader, doc, offsetsEnums);
        } else {
            BytesRef[] insensitiveTerms;
            PhraseHelper phraseHelper = this.components.getPhraseHelper();
            BytesRef[] terms = this.components.getTerms();
            if (phraseHelper.hasPositionSensitivity()) {
                insensitiveTerms = phraseHelper.getAllPositionInsensitiveTerms();
                assert (insensitiveTerms.length <= terms.length) : "insensitive terms should be smaller set of all terms";
            } else {
                insensitiveTerms = terms;
            }
            if (insensitiveTerms.length > 0) {
                this.createOffsetsEnumsForTerms(insensitiveTerms, termsIndex, doc, offsetsEnums);
            }
            if (phraseHelper.hasPositionSensitivity()) {
                phraseHelper.createOffsetsEnumsForSpans(leafReader, doc, offsetsEnums);
            }
            if (this.components.getAutomata().length > 0) {
                this.createOffsetsEnumsForAutomata(termsIndex, doc, offsetsEnums);
            }
        }
        switch (offsetsEnums.size()) {
            case 0: {
                return OffsetsEnum.EMPTY;
            }
            case 1: {
                return (OffsetsEnum)offsetsEnums.get(0);
            }
        }
        return new OffsetsEnum.MultiOffsetsEnum(offsetsEnums);
    }

    protected void createOffsetsEnumsWeightMatcher(LeafReader _leafReader, int docId, List<OffsetsEnum> results) throws IOException {
        FilterLeafReader leafReader = new FilterLeafReader(_leafReader){

            public Terms terms(String field) throws IOException {
                if (FieldOffsetStrategy.this.components.getFieldMatcher().test(field)) {
                    return super.terms(FieldOffsetStrategy.this.components.getField());
                }
                return super.terms(field);
            }

            public IndexReader.CacheHelper getCoreCacheHelper() {
                return null;
            }

            public IndexReader.CacheHelper getReaderCacheHelper() {
                return null;
            }
        };
        IndexSearcher indexSearcher = new IndexSearcher((IndexReader)leafReader);
        indexSearcher.setQueryCache(null);
        Matches matches = indexSearcher.rewrite(this.components.getQuery()).createWeight(indexSearcher, ScoreMode.COMPLETE_NO_SCORES, 1.0f).matches(leafReader.getContext(), docId);
        if (matches == null) {
            return;
        }
        for (String field : matches) {
            MatchesIterator iterator;
            if (!this.components.getFieldMatcher().test(field) || (iterator = matches.getMatches(field)) == null) continue;
            results.add(new OffsetsEnum.OfMatchesIteratorWithSubs(iterator));
        }
    }

    protected void createOffsetsEnumsForTerms(BytesRef[] sourceTerms, Terms termsIndex, int doc, List<OffsetsEnum> results) throws IOException {
        TermsEnum termsEnum = termsIndex.iterator();
        for (BytesRef term : sourceTerms) {
            if (!termsEnum.seekExact(term)) continue;
            PostingsEnum postingsEnum = termsEnum.postings(null, 56);
            if (postingsEnum == null) {
                throw new IllegalArgumentException("field '" + this.getField() + "' was indexed without offsets, cannot highlight");
            }
            if (doc != postingsEnum.advance(doc)) continue;
            results.add(new OffsetsEnum.OfPostings(term, postingsEnum));
        }
    }

    protected void createOffsetsEnumsForAutomata(Terms termsIndex, int doc, List<OffsetsEnum> results) throws IOException {
        CharacterRunAutomaton automaton;
        int i;
        BytesRef term;
        CharacterRunAutomaton[] automata = this.components.getAutomata();
        ArrayList automataPostings = new ArrayList(automata.length);
        for (int i2 = 0; i2 < automata.length; ++i2) {
            automataPostings.add(new ArrayList());
        }
        TermsEnum termsEnum = termsIndex.iterator();
        CharsRefBuilder refBuilder = new CharsRefBuilder();
        while ((term = termsEnum.next()) != null) {
            for (i = 0; i < automata.length; ++i) {
                PostingsEnum postings;
                automaton = automata[i];
                refBuilder.copyUTF8Bytes(term);
                if (!automaton.run(refBuilder.chars(), 0, refBuilder.length()) || doc != (postings = termsEnum.postings(null, 56)).advance(doc)) continue;
                ((List)automataPostings.get(i)).add(postings);
            }
        }
        for (i = 0; i < automata.length; ++i) {
            automaton = automata[i];
            List postingsEnums = (List)automataPostings.get(i);
            if (postingsEnums.isEmpty()) continue;
            BytesRef wildcardTerm = new BytesRef((CharSequence)automaton.toString());
            int sumFreq = 0;
            for (PostingsEnum postingsEnum : postingsEnums) {
                sumFreq += postingsEnum.freq();
            }
            for (PostingsEnum postingsEnum : postingsEnums) {
                results.add(new OffsetsEnum.OfPostings(wildcardTerm, sumFreq, postingsEnum));
            }
        }
    }
}

