/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.client.impl.CorruptFileBlockIterator;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class Hdfs
extends AbstractFileSystem {
    DFSClient dfs;
    private boolean verifyChecksum = true;

    Hdfs(URI theUri, Configuration conf) throws IOException, URISyntaxException {
        super(theUri, "hdfs", true, 8020);
        if (!theUri.getScheme().equalsIgnoreCase("hdfs")) {
            throw new IllegalArgumentException("Passed URI's scheme is not for Hdfs");
        }
        String host = theUri.getHost();
        if (host == null) {
            throw new IOException("Incomplete HDFS URI, no host: " + theUri);
        }
        this.dfs = new DFSClient(theUri, conf, this.getStatistics());
    }

    public int getUriDefaultPort() {
        return 8020;
    }

    public HdfsDataOutputStream createInternal(Path f, EnumSet<CreateFlag> createFlag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws IOException {
        DFSOutputStream dfsos = this.dfs.primitiveCreate(this.getUriPath(f), absolutePermission, createFlag, createParent, replication, blockSize, progress, bufferSize, checksumOpt);
        return this.dfs.createWrappedOutputStream(dfsos, this.statistics, dfsos.getInitialLen());
    }

    public boolean delete(Path f, boolean recursive) throws IOException, UnresolvedLinkException {
        return this.dfs.delete(this.getUriPath(f), recursive);
    }

    public BlockLocation[] getFileBlockLocations(Path p, long start, long len) throws IOException, UnresolvedLinkException {
        return this.dfs.getBlockLocations(this.getUriPath(p), start, len);
    }

    public FileChecksum getFileChecksum(Path f) throws IOException, UnresolvedLinkException {
        return this.dfs.getFileChecksumWithCombineMode(this.getUriPath(f), Long.MAX_VALUE);
    }

    public FileStatus getFileStatus(Path f) throws IOException, UnresolvedLinkException {
        HdfsFileStatus fi = this.dfs.getFileInfo(this.getUriPath(f));
        if (fi != null) {
            return fi.makeQualified(this.getUri(), f);
        }
        throw new FileNotFoundException("File does not exist: " + f.toString());
    }

    public FileStatus getFileLinkStatus(Path f) throws IOException, UnresolvedLinkException {
        HdfsFileStatus fi = this.dfs.getFileLinkInfo(this.getUriPath(f));
        if (fi != null) {
            return fi.makeQualified(this.getUri(), f);
        }
        throw new FileNotFoundException("File does not exist: " + f);
    }

    public FsStatus getFsStatus() throws IOException {
        return this.dfs.getDiskStatus();
    }

    @Deprecated
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.dfs.getServerDefaults();
    }

    public FsServerDefaults getServerDefaults(Path f) throws IOException {
        return this.dfs.getServerDefaults();
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path p) throws FileNotFoundException, IOException {
        return new DirListingIterator<LocatedFileStatus>(p, true){

            public LocatedFileStatus next() throws IOException {
                return ((HdfsLocatedFileStatus)this.getNext()).makeQualifiedLocated(Hdfs.this.getUri(), p);
            }
        };
    }

    public RemoteIterator<FileStatus> listStatusIterator(final Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return new DirListingIterator<FileStatus>(f, false){

            public FileStatus next() throws IOException {
                return this.getNext().makeQualified(Hdfs.this.getUri(), f);
            }
        };
    }

    public FileStatus[] listStatus(Path f) throws IOException, UnresolvedLinkException {
        String src = this.getUriPath(f);
        DirectoryListing thisListing = this.dfs.listPaths(src, HdfsFileStatus.EMPTY_NAME);
        if (thisListing == null) {
            throw new FileNotFoundException("File " + f + " does not exist.");
        }
        HdfsFileStatus[] partialListing = thisListing.getPartialListing();
        if (!thisListing.hasMore()) {
            FileStatus[] stats = new FileStatus[partialListing.length];
            for (int i = 0; i < partialListing.length; ++i) {
                stats[i] = partialListing[i].makeQualified(this.getUri(), f);
            }
            return stats;
        }
        int totalNumEntries = partialListing.length + thisListing.getRemainingEntries();
        ArrayList<FileStatus> listing = new ArrayList<FileStatus>(totalNumEntries);
        for (HdfsFileStatus fileStatus : partialListing) {
            listing.add(fileStatus.makeQualified(this.getUri(), f));
        }
        do {
            if ((thisListing = this.dfs.listPaths(src, thisListing.getLastName())) == null) {
                throw new FileNotFoundException("File " + f + " does not exist.");
            }
            for (HdfsFileStatus fileStatus : partialListing = thisListing.getPartialListing()) {
                listing.add(fileStatus.makeQualified(this.getUri(), f));
            }
        } while (thisListing.hasMore());
        return listing.toArray(new FileStatus[listing.size()]);
    }

    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        return new CorruptFileBlockIterator(this.dfs, path);
    }

    public void mkdir(Path dir, FsPermission permission, boolean createParent) throws IOException, UnresolvedLinkException {
        this.dfs.primitiveMkdir(this.getUriPath(dir), permission, createParent);
    }

    public HdfsDataInputStream open(Path f, int bufferSize) throws IOException, UnresolvedLinkException {
        DFSInputStream dfsis = this.dfs.open(this.getUriPath(f), bufferSize, this.verifyChecksum);
        return this.dfs.createWrappedInputStream(dfsis);
    }

    public boolean truncate(Path f, long newLength) throws IOException, UnresolvedLinkException {
        return this.dfs.truncate(this.getUriPath(f), newLength);
    }

    public void renameInternal(Path src, Path dst) throws IOException, UnresolvedLinkException {
        this.dfs.rename(this.getUriPath(src), this.getUriPath(dst), Options.Rename.NONE);
    }

    public void renameInternal(Path src, Path dst, boolean overwrite) throws IOException, UnresolvedLinkException {
        this.dfs.rename(this.getUriPath(src), this.getUriPath(dst), overwrite ? Options.Rename.OVERWRITE : Options.Rename.NONE);
    }

    public void setOwner(Path f, String username, String groupname) throws IOException, UnresolvedLinkException {
        this.dfs.setOwner(this.getUriPath(f), username, groupname);
    }

    public void setPermission(Path f, FsPermission permission) throws IOException, UnresolvedLinkException {
        this.dfs.setPermission(this.getUriPath(f), permission);
    }

    public boolean setReplication(Path f, short replication) throws IOException, UnresolvedLinkException {
        return this.dfs.setReplication(this.getUriPath(f), replication);
    }

    public void setTimes(Path f, long mtime, long atime) throws IOException, UnresolvedLinkException {
        this.dfs.setTimes(this.getUriPath(f), mtime, atime);
    }

    public void setVerifyChecksum(boolean verifyChecksum) throws IOException {
        this.verifyChecksum = verifyChecksum;
    }

    public boolean supportsSymlinks() {
        return true;
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws IOException, UnresolvedLinkException {
        this.dfs.createSymlink(target.toString(), this.getUriPath(link), createParent);
    }

    public Path getLinkTarget(Path p) throws IOException {
        return new Path(this.dfs.getLinkTarget(this.getUriPath(p)));
    }

    public String getCanonicalServiceName() {
        return this.dfs.getCanonicalServiceName();
    }

    public List<Token<?>> getDelegationTokens(String renewer) throws IOException {
        Token<DelegationTokenIdentifier> result = this.dfs.getDelegationToken(renewer == null ? null : new Text(renewer));
        ArrayList tokenList = new ArrayList();
        tokenList.add(result);
        return tokenList;
    }

    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.dfs.modifyAclEntries(this.getUriPath(path), aclSpec);
    }

    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.dfs.removeAclEntries(this.getUriPath(path), aclSpec);
    }

    public void removeDefaultAcl(Path path) throws IOException {
        this.dfs.removeDefaultAcl(this.getUriPath(path));
    }

    public void removeAcl(Path path) throws IOException {
        this.dfs.removeAcl(this.getUriPath(path));
    }

    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        this.dfs.setAcl(this.getUriPath(path), aclSpec);
    }

    public AclStatus getAclStatus(Path path) throws IOException {
        return this.dfs.getAclStatus(this.getUriPath(path));
    }

    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.dfs.setXAttr(this.getUriPath(path), name, value, flag);
    }

    public byte[] getXAttr(Path path, String name) throws IOException {
        return this.dfs.getXAttr(this.getUriPath(path), name);
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        return this.dfs.getXAttrs(this.getUriPath(path));
    }

    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        return this.dfs.getXAttrs(this.getUriPath(path), names);
    }

    public List<String> listXAttrs(Path path) throws IOException {
        return this.dfs.listXAttrs(this.getUriPath(path));
    }

    public void removeXAttr(Path path, String name) throws IOException {
        this.dfs.removeXAttr(this.getUriPath(path), name);
    }

    public void access(Path path, FsAction mode) throws IOException {
        this.dfs.checkAccess(this.getUriPath(path), mode);
    }

    public void setStoragePolicy(Path path, String policyName) throws IOException {
        this.dfs.setStoragePolicy(this.getUriPath(path), policyName);
    }

    public void unsetStoragePolicy(Path src) throws IOException {
        this.dfs.unsetStoragePolicy(this.getUriPath(src));
    }

    public BlockStoragePolicySpi getStoragePolicy(Path src) throws IOException {
        return this.dfs.getStoragePolicy(this.getUriPath(src));
    }

    public Collection<? extends BlockStoragePolicySpi> getAllStoragePolicies() throws IOException {
        return Arrays.asList(this.dfs.getStoragePolicies());
    }

    public long renewDelegationToken(Token<? extends AbstractDelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        return this.dfs.renewDelegationToken(token);
    }

    public void cancelDelegationToken(Token<? extends AbstractDelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        this.dfs.cancelDelegationToken(token);
    }

    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        return new Path(this.dfs.createSnapshot(this.getUriPath(path), snapshotName));
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.dfs.renameSnapshot(this.getUriPath(path), snapshotOldName, snapshotNewName);
    }

    public void deleteSnapshot(Path snapshotDir, String snapshotName) throws IOException {
        this.dfs.deleteSnapshot(this.getUriPath(snapshotDir), snapshotName);
    }

    static {
        HdfsConfiguration.init();
    }

    private abstract class DirListingIterator<T extends FileStatus>
    implements RemoteIterator<T> {
        private DirectoryListing thisListing;
        private int i;
        private final String src;
        private final boolean needLocation;

        private DirListingIterator(Path p, boolean needLocation) throws IOException {
            this.src = Hdfs.this.getUriPath(p);
            this.needLocation = needLocation;
            this.thisListing = Hdfs.this.dfs.listPaths(this.src, HdfsFileStatus.EMPTY_NAME, needLocation);
            if (this.thisListing == null) {
                throw new FileNotFoundException("File " + this.src + " does not exist.");
            }
        }

        public boolean hasNext() throws IOException {
            if (this.thisListing == null) {
                return false;
            }
            if (this.i >= this.thisListing.getPartialListing().length && this.thisListing.hasMore()) {
                this.thisListing = Hdfs.this.dfs.listPaths(this.src, this.thisListing.getLastName(), this.needLocation);
                if (this.thisListing == null) {
                    throw new FileNotFoundException("File " + this.src + " does not exist.");
                }
                this.i = 0;
            }
            return this.i < this.thisListing.getPartialListing().length;
        }

        public HdfsFileStatus getNext() throws IOException {
            if (this.hasNext()) {
                return this.thisListing.getPartialListing()[this.i++];
            }
            throw new NoSuchElementException("No more entry in " + this.src);
        }
    }
}

