/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling.sim;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.jute.Record;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AlreadyExistsException;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.BadVersionException;
import org.apache.solr.client.solrj.cloud.autoscaling.NotEmptyException;
import org.apache.solr.client.solrj.cloud.autoscaling.VersionedData;
import org.apache.solr.cloud.ActionThrottle;
import org.apache.solr.cloud.autoscaling.sim.ActionError;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.Utils;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.IdUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.CheckVersionRequest;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.DeleteRequest;
import org.apache.zookeeper.proto.SetDataRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimDistribStateManager
implements DistribStateManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ReentrantLock multiLock = new ReentrantLock();
    private final ExecutorService watchersPool;
    private final AtomicReference<ActionThrottle> throttleRef = new AtomicReference();
    private final AtomicReference<ActionError> errorRef = new AtomicReference();
    private final String id;
    private final Node root;
    private int juteMaxbuffer = 1048575;

    public static Node createNewRootNode() {
        return new Node(null, "", "/", CreateMode.PERSISTENT, "0");
    }

    public SimDistribStateManager() {
        this(null);
    }

    public SimDistribStateManager(Node root) {
        this.id = IdUtils.timeRandomId();
        this.root = root != null ? root : SimDistribStateManager.createNewRootNode();
        this.watchersPool = ExecutorUtil.newMDCAwareFixedThreadPool((int)10, (ThreadFactory)new DefaultSolrThreadFactory("sim-watchers"));
        String bufferSize = System.getProperty("jute.maxbuffer", Integer.toString(0xFFFFFF));
        this.juteMaxbuffer = Integer.parseInt(bufferSize);
    }

    public void copyFrom(DistribStateManager other, boolean failOnExists) throws InterruptedException, IOException, KeeperException, AlreadyExistsException, BadVersionException {
        List tree = other.listTree("/");
        log.info("- copying " + tree.size() + " resources...");
        for (String path : tree) {
            if (!this.hasData(path) || !failOnExists) continue;
            throw new AlreadyExistsException(path);
        }
        for (String path : tree) {
            VersionedData data = other.getData(path);
            if (this.hasData(path)) {
                this.setData(path, data.getData(), -1);
            } else {
                this.makePath(path, data.getData(), data.getMode(), failOnExists);
            }
            Node n = this.traverse(path, false, CreateMode.PERSISTENT);
            n.version = data.getVersion();
            n.owner = data.getOwner();
        }
    }

    public SimDistribStateManager(ActionThrottle actionThrottle, ActionError actionError) {
        this(null, actionThrottle, actionError);
    }

    public SimDistribStateManager(Node root, ActionThrottle actionThrottle, ActionError actionError) {
        this(root);
        this.throttleRef.set(actionThrottle);
        this.errorRef.set(actionError);
    }

    private SimDistribStateManager(String id, ExecutorService watchersPool, Node root, ActionThrottle actionThrottle, ActionError actionError) {
        this.id = id;
        this.watchersPool = watchersPool;
        this.root = root;
        this.throttleRef.set(actionThrottle);
        this.errorRef.set(actionError);
    }

    public SimDistribStateManager withEphemeralId(String id) {
        return new SimDistribStateManager(id, this.watchersPool, this.root, this.throttleRef.get(), this.errorRef.get()){

            @Override
            public void close() {
                throw new UnsupportedOperationException("this instance should never be closed - instead close the parent instance.");
            }
        };
    }

    public Node getRoot() {
        return this.root;
    }

    public void clear() {
        this.root.clear();
    }

    private void throttleOrError(String path) throws IOException {
        ActionError err = this.errorRef.get();
        if (err != null && err.shouldFail(path)) {
            throw new IOException("Simulated error, path=" + path);
        }
        ActionThrottle throttle = this.throttleRef.get();
        if (throttle != null) {
            throttle.minimumWaitBetweenActions();
            throttle.markAttemptingAction();
        }
    }

    private Node traverse(String path, boolean create, CreateMode mode) throws IOException {
        if (path == null || path.isEmpty()) {
            return null;
        }
        this.throttleOrError(path);
        if (path.equals("/")) {
            return this.root;
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        StringBuilder currentPath = new StringBuilder();
        String[] elements = path.split("/");
        Node parentNode = this.root;
        Node n = null;
        for (int i = 0; i < elements.length; ++i) {
            String currentName = elements[i];
            currentPath.append('/');
            Node node = n = parentNode.children != null ? (Node)parentNode.children.get(currentName) : null;
            if (n == null) {
                if (!create) break;
                n = this.createNode(parentNode, mode, currentPath, currentName, null, true);
            } else {
                currentPath.append(currentName);
            }
            parentNode = n;
        }
        return n;
    }

    private Node createNode(Node parentNode, CreateMode mode, StringBuilder fullChildPath, String baseChildName, byte[] data, boolean attachToParent) throws IOException {
        String nodeName = baseChildName;
        if (!(parentNode.mode != CreateMode.EPHEMERAL && parentNode.mode != CreateMode.EPHEMERAL_SEQUENTIAL || mode != CreateMode.EPHEMERAL && mode != CreateMode.EPHEMERAL_SEQUENTIAL)) {
            throw new IOException("NoChildrenEphemerals for " + parentNode.path);
        }
        if (CreateMode.PERSISTENT_SEQUENTIAL == mode || CreateMode.EPHEMERAL_SEQUENTIAL == mode) {
            nodeName = nodeName + String.format(Locale.ROOT, "%010d", parentNode.seq);
            parentNode.seq++;
        }
        fullChildPath.append(nodeName);
        String owner = mode == CreateMode.EPHEMERAL || mode == CreateMode.EPHEMERAL_SEQUENTIAL ? this.id : "0";
        Node child = new Node(parentNode, nodeName, fullChildPath.toString(), data, mode, owner);
        if (attachToParent) {
            parentNode.setChild(nodeName, child);
        }
        return child;
    }

    public void close() throws IOException {
        this.multiLock.lock();
        try {
            this.root.removeEphemeralChildren(this.id);
        }
        catch (BadVersionException badVersionException) {
        }
        finally {
            this.multiLock.unlock();
        }
    }

    public boolean hasData(String path) throws IOException {
        this.multiLock.lock();
        try {
            boolean bl = this.traverse(path, false, CreateMode.PERSISTENT) != null;
            return bl;
        }
        finally {
            this.multiLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listData(String path) throws NoSuchElementException, IOException {
        this.multiLock.lock();
        try {
            Node n = this.traverse(path, false, CreateMode.PERSISTENT);
            if (n == null) {
                throw new NoSuchElementException(path);
            }
            ArrayList<String> res = new ArrayList<String>(n.children.keySet());
            Collections.sort(res);
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        finally {
            this.multiLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listData(String path, Watcher watcher) throws NoSuchElementException, IOException {
        ArrayList<String> res;
        Node n;
        this.multiLock.lock();
        try {
            n = this.traverse(path, false, CreateMode.PERSISTENT);
            if (n == null) {
                throw new NoSuchElementException(path);
            }
            res = new ArrayList<String>(n.children.keySet());
            Collections.sort(res);
        }
        finally {
            this.multiLock.unlock();
        }
        if (watcher != null) {
            n.dataWatches.add(watcher);
            n.childrenWatches.add(watcher);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedData getData(String path, Watcher watcher) throws NoSuchElementException, IOException {
        Node n = null;
        this.multiLock.lock();
        try {
            n = this.traverse(path, false, CreateMode.PERSISTENT);
            if (n == null) {
                throw new NoSuchElementException(path);
            }
        }
        finally {
            this.multiLock.unlock();
        }
        return n.getData(watcher);
    }

    public void makePath(String path) throws IOException {
        this.multiLock.lock();
        try {
            this.traverse(path, true, CreateMode.PERSISTENT);
        }
        finally {
            this.multiLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePath(String path, byte[] data, CreateMode createMode, boolean failOnExists) throws AlreadyExistsException, IOException, KeeperException, InterruptedException {
        Node n = null;
        this.multiLock.lock();
        try {
            if (failOnExists && this.hasData(path)) {
                throw new AlreadyExistsException(path);
            }
            n = this.traverse(path, true, createMode);
        }
        finally {
            this.multiLock.unlock();
        }
        try {
            n.setData(data, -1);
        }
        catch (BadVersionException e) {
            throw new IOException("should not happen!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createData(String path, byte[] data, CreateMode mode) throws AlreadyExistsException, NoSuchElementException, IOException {
        String relPath;
        if ((CreateMode.EPHEMERAL == mode || CreateMode.PERSISTENT == mode) && this.hasData(path)) {
            throw new AlreadyExistsException(path);
        }
        String string = relPath = path.charAt(0) == '/' ? path.substring(1) : path;
        if (relPath.length() == 0) {
            return null;
        }
        String[] elements = relPath.split("/");
        StringBuilder parentStringBuilder = new StringBuilder();
        Node parentNode = null;
        if (elements.length == 1) {
            parentNode = this.getRoot();
        } else {
            for (int i = 0; i < elements.length - 1; ++i) {
                parentStringBuilder.append('/');
                parentStringBuilder.append(elements[i]);
            }
            if (!this.hasData(parentStringBuilder.toString())) {
                throw new NoSuchElementException(parentStringBuilder.toString());
            }
            parentNode = this.traverse(parentStringBuilder.toString(), false, mode);
        }
        this.multiLock.lock();
        try {
            String nodeName = elements[elements.length - 1];
            Node childNode = this.createNode(parentNode, mode, parentStringBuilder.append("/"), nodeName, data, false);
            parentNode.setChild(childNode.name, childNode);
            String string2 = childNode.path;
            return string2;
        }
        finally {
            this.multiLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeData(String path, int version) throws NoSuchElementException, NotEmptyException, BadVersionException, IOException {
        Node parent;
        Node n;
        this.multiLock.lock();
        try {
            n = this.traverse(path, false, CreateMode.PERSISTENT);
            if (n == null) {
                throw new NoSuchElementException(path);
            }
            parent = n.parent;
            if (parent == null) {
                throw new IOException("Cannot remove root node");
            }
            if (!n.children.isEmpty()) {
                throw new NotEmptyException(path);
            }
        }
        finally {
            this.multiLock.unlock();
        }
        parent.removeChild(n.name, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String path, byte[] data, int version) throws NoSuchElementException, BadVersionException, IOException {
        if (data != null && data.length > this.juteMaxbuffer) {
            throw new IOException("Len error " + data.length);
        }
        this.multiLock.lock();
        Node n = null;
        try {
            n = this.traverse(path, false, CreateMode.PERSISTENT);
            if (n == null) {
                throw new NoSuchElementException(path);
            }
        }
        finally {
            this.multiLock.unlock();
        }
        n.setData(data, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OpResult> multi(Iterable<Op> ops) throws BadVersionException, NoSuchElementException, AlreadyExistsException, IOException, KeeperException, InterruptedException {
        this.multiLock.lock();
        ArrayList<OpResult> res = new ArrayList<OpResult>();
        try {
            for (Op op : ops) {
                Record r = op.toRequestRecord();
                try {
                    CheckVersionRequest rr;
                    if (op instanceof Op.Check) {
                        rr = (CheckVersionRequest)r;
                        Node n = this.traverse(rr.getPath(), false, CreateMode.PERSISTENT);
                        if (n == null) {
                            throw new NoSuchElementException(rr.getPath());
                        }
                        if (rr.getVersion() != -1 && n.version != rr.getVersion()) {
                            throw new Exception("version mismatch");
                        }
                        res.add((OpResult)new OpResult.CheckResult());
                        continue;
                    }
                    if (op instanceof Op.Create) {
                        rr = (CreateRequest)r;
                        this.createData(rr.getPath(), rr.getData(), CreateMode.fromFlag((int)rr.getFlags()));
                        res.add((OpResult)new OpResult.CreateResult(rr.getPath()));
                        continue;
                    }
                    if (op instanceof Op.Delete) {
                        rr = (DeleteRequest)r;
                        this.removeData(rr.getPath(), rr.getVersion());
                        res.add((OpResult)new OpResult.DeleteResult());
                        continue;
                    }
                    if (op instanceof Op.SetData) {
                        rr = (SetDataRequest)r;
                        this.setData(rr.getPath(), rr.getData(), rr.getVersion());
                        VersionedData vd = this.getData(rr.getPath());
                        Stat s = new Stat();
                        s.setVersion(vd.getVersion());
                        res.add((OpResult)new OpResult.SetDataResult(s));
                        continue;
                    }
                    throw new Exception("Unknown Op: " + op);
                }
                catch (Exception e) {
                    res.add((OpResult)new OpResult.ErrorResult(KeeperException.Code.APIERROR.intValue()));
                }
            }
        }
        finally {
            this.multiLock.unlock();
        }
        return res;
    }

    public AutoScalingConfig getAutoScalingConfig(Watcher watcher) throws InterruptedException, IOException {
        Map<String, Integer> map = new HashMap<String, Integer>();
        int version = 0;
        try {
            VersionedData data = this.getData("/autoscaling.json", watcher);
            if (data != null && data.getData() != null && data.getData().length > 0) {
                map = (Map)Utils.fromJSON((byte[])data.getData());
                version = data.getVersion();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        map.put("zkVersion", version);
        return new AutoScalingConfig(map);
    }

    public void simSetAutoScalingConfig(AutoScalingConfig cfg) throws Exception {
        try {
            this.makePath("/autoscaling.json");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setData("/autoscaling.json", Utils.toJSON((Object)cfg), -1);
    }

    public static final class Node {
        ReentrantLock dataLock = new ReentrantLock();
        private int version = 0;
        private int seq = 0;
        private final CreateMode mode;
        private String owner;
        private final String path;
        private final String name;
        private final Node parent;
        private byte[] data = null;
        private Map<String, Node> children = new ConcurrentHashMap<String, Node>();
        Set<Watcher> dataWatches = ConcurrentHashMap.newKeySet();
        Set<Watcher> childrenWatches = ConcurrentHashMap.newKeySet();

        Node(Node parent, String name, String path, CreateMode mode, String owner) {
            this.parent = parent;
            this.name = name;
            this.path = path;
            this.mode = mode;
            this.owner = owner;
        }

        Node(Node parent, String name, String path, byte[] data, CreateMode mode, String owner) {
            this(parent, name, path, mode, owner);
            this.data = data;
        }

        public void clear() {
            this.dataLock.lock();
            try {
                this.children.clear();
                this.version = 0;
                this.seq = 0;
                this.dataWatches.clear();
                this.childrenWatches.clear();
                this.data = null;
            }
            finally {
                this.dataLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setData(byte[] data, int version) throws BadVersionException, IOException {
            HashSet<Watcher> currentWatchers = new HashSet<Watcher>(this.dataWatches);
            this.dataLock.lock();
            try {
                if (version != -1 && version != this.version) {
                    throw new BadVersionException(version, this.path);
                }
                this.data = (byte[])(data != null ? Arrays.copyOf(data, data.length) : null);
                ++this.version;
                this.dataWatches.clear();
            }
            finally {
                this.dataLock.unlock();
            }
            for (Watcher w : currentWatchers) {
                w.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, this.path));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VersionedData getData(Watcher w) {
            this.dataLock.lock();
            try {
                VersionedData res = new VersionedData(this.version, this.data, this.mode, this.owner);
                if (w != null && !this.dataWatches.contains(w)) {
                    this.dataWatches.add(w);
                }
                VersionedData versionedData = res;
                return versionedData;
            }
            finally {
                this.dataLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setChild(String name, Node child) {
            assert (child.name.equals(name));
            HashSet<Watcher> currentWatchers = new HashSet<Watcher>(this.childrenWatches);
            this.dataLock.lock();
            try {
                this.children.put(name, child);
                this.childrenWatches.clear();
            }
            finally {
                this.dataLock.unlock();
            }
            for (Watcher w : currentWatchers) {
                w.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, this.path));
            }
        }

        public void removeChild(String name, int version) throws NoSuchElementException, BadVersionException, IOException {
            Node n = this.children.get(name);
            if (n == null) {
                throw new NoSuchElementException(this.path + "/" + name);
            }
            if (version != -1 && version != n.version) {
                throw new BadVersionException(version, this.path);
            }
            this.children.remove(name);
            HashSet<Watcher> currentWatchers = new HashSet<Watcher>(this.childrenWatches);
            this.childrenWatches.clear();
            for (Watcher w : currentWatchers) {
                w.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, this.path));
            }
            currentWatchers = new HashSet<Watcher>(n.dataWatches);
            n.dataWatches.clear();
            for (Watcher w : currentWatchers) {
                w.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, n.path));
            }
            HashSet<String> kids = new HashSet<String>(n.children.keySet());
            for (String kid : kids) {
                n.removeChild(kid, -1);
            }
        }

        public void removeEphemeralChildren(String id) throws NoSuchElementException, BadVersionException, IOException {
            HashSet<String> kids = new HashSet<String>(this.children.keySet());
            for (String kid : kids) {
                Node n = this.children.get(kid);
                if (n == null) continue;
                if ((CreateMode.EPHEMERAL == n.mode || CreateMode.EPHEMERAL_SEQUENTIAL == n.mode) && id.equals(n.owner)) {
                    this.removeChild(n.name, -1);
                    continue;
                }
                n.removeEphemeralChildren(id);
            }
        }
    }
}

