/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDoubleMerger;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.SimpleAggValueSource;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.VarianceSlotAcc;

public class VarianceAgg
extends SimpleAggValueSource {
    public VarianceAgg(ValueSource vs) {
        super("variance", vs);
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, int numDocs, int numSlots) throws IOException {
        return new VarianceSlotAcc(this.getArg(), fcontext, numSlots);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new Merger();
    }

    private static class Merger
    extends FacetDoubleMerger {
        long count;
        double sumSq;
        double sum;

        private Merger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext1) {
            List numberList = (List)facetResult;
            this.count += ((Number)numberList.get(0)).longValue();
            this.sumSq += ((Number)numberList.get(1)).doubleValue();
            this.sum += ((Number)numberList.get(2)).doubleValue();
        }

        @Override
        public Object getMergedResult() {
            return this.getDouble();
        }

        @Override
        protected double getDouble() {
            double val = this.count == 0L ? 0.0 : this.sumSq / (double)this.count - Math.pow(this.sum / (double)this.count, 2.0);
            return val;
        }
    }
}

