/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.BooleanFillMissingFunction;
import org.apache.solr.analytics.function.mapping.BooleanStreamFillMissingFunction;
import org.apache.solr.analytics.function.mapping.DateFillMissingFunction;
import org.apache.solr.analytics.function.mapping.DateStreamFillMissingFunction;
import org.apache.solr.analytics.function.mapping.DoubleFillMissingFunction;
import org.apache.solr.analytics.function.mapping.DoubleStreamFillMissingFunction;
import org.apache.solr.analytics.function.mapping.FloatFillMissingFunction;
import org.apache.solr.analytics.function.mapping.FloatStreamFillMissingFunction;
import org.apache.solr.analytics.function.mapping.IntFillMissingFunction;
import org.apache.solr.analytics.function.mapping.IntStreamFillMissingFunction;
import org.apache.solr.analytics.function.mapping.LongFillMissingFunction;
import org.apache.solr.analytics.function.mapping.LongStreamFillMissingFunction;
import org.apache.solr.analytics.function.mapping.StreamFillMissingFunction;
import org.apache.solr.analytics.function.mapping.StringFillMissingFunction;
import org.apache.solr.analytics.function.mapping.StringStreamFillMissingFunction;
import org.apache.solr.analytics.function.mapping.ValueFillMissingFunction;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class FillMissingFunction {
    public static final String name = "fill_missing";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The fill_missing function requires 2 paramaters, " + params.length + " found.");
        }
        AnalyticsValueStream baseExpr = params[0];
        AnalyticsValueStream fillExpr = params[1];
        if (baseExpr instanceof DateValue && fillExpr instanceof DateValue) {
            return new DateFillMissingFunction((DateValue)baseExpr, (DateValue)fillExpr);
        }
        if (baseExpr instanceof DateValueStream && fillExpr instanceof DateValueStream) {
            return new DateStreamFillMissingFunction((DateValueStream)baseExpr, (DateValueStream)fillExpr);
        }
        if (baseExpr instanceof BooleanValue && fillExpr instanceof BooleanValue) {
            return new BooleanFillMissingFunction((BooleanValue)baseExpr, (BooleanValue)fillExpr);
        }
        if (baseExpr instanceof BooleanValueStream && fillExpr instanceof BooleanValueStream) {
            return new BooleanStreamFillMissingFunction((BooleanValueStream)baseExpr, (BooleanValueStream)fillExpr);
        }
        if (baseExpr instanceof IntValue && fillExpr instanceof IntValue) {
            return new IntFillMissingFunction((IntValue)baseExpr, (IntValue)fillExpr);
        }
        if (baseExpr instanceof IntValueStream && fillExpr instanceof IntValueStream) {
            return new IntStreamFillMissingFunction((IntValueStream)baseExpr, (IntValueStream)fillExpr);
        }
        if (baseExpr instanceof LongValue && fillExpr instanceof LongValue) {
            return new LongFillMissingFunction((LongValue)baseExpr, (LongValue)fillExpr);
        }
        if (baseExpr instanceof LongValueStream && fillExpr instanceof LongValueStream) {
            return new LongStreamFillMissingFunction((LongValueStream)baseExpr, (LongValueStream)fillExpr);
        }
        if (baseExpr instanceof FloatValue && fillExpr instanceof FloatValue) {
            return new FloatFillMissingFunction((FloatValue)baseExpr, (FloatValue)fillExpr);
        }
        if (baseExpr instanceof FloatValueStream && fillExpr instanceof FloatValueStream) {
            return new FloatStreamFillMissingFunction((FloatValueStream)baseExpr, (FloatValueStream)fillExpr);
        }
        if (baseExpr instanceof DoubleValue && fillExpr instanceof DoubleValue) {
            return new DoubleFillMissingFunction((DoubleValue)baseExpr, (DoubleValue)fillExpr);
        }
        if (baseExpr instanceof DoubleValueStream && fillExpr instanceof DoubleValueStream) {
            return new DoubleStreamFillMissingFunction((DoubleValueStream)baseExpr, (DoubleValueStream)fillExpr);
        }
        if (baseExpr instanceof StringValue && fillExpr instanceof StringValue) {
            return new StringFillMissingFunction((StringValue)baseExpr, (StringValue)fillExpr);
        }
        if (baseExpr instanceof StringValueStream && fillExpr instanceof StringValueStream) {
            return new StringStreamFillMissingFunction((StringValueStream)baseExpr, (StringValueStream)fillExpr);
        }
        if (baseExpr instanceof AnalyticsValue && fillExpr instanceof AnalyticsValue) {
            return new ValueFillMissingFunction((AnalyticsValue)baseExpr, (AnalyticsValue)fillExpr);
        }
        return new StreamFillMissingFunction(baseExpr, fillExpr);
    };
}

