/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.ExtProperties;

public class SolrParamResourceLoader
extends ResourceLoader {
    public static final String TEMPLATE_PARAM_PREFIX = "v.template.";
    private Map<String, String> templates = new HashMap<String, String>();

    public SolrParamResourceLoader(SolrQueryRequest request) {
        SolrParams params = request.getParams();
        Iterator names = params.getParameterNamesIterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            if (!name.startsWith(TEMPLATE_PARAM_PREFIX)) continue;
            this.templates.put(name.substring(TEMPLATE_PARAM_PREFIX.length()) + ".vm", params.get(name));
        }
    }

    public void init(ExtProperties extendedProperties) {
    }

    public Reader getResourceReader(String source, String encoding) throws ResourceNotFoundException {
        String template = this.templates.get(source);
        return template == null ? null : new StringReader(template);
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

