/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.thrift.internal.senders;

import io.jaegertracing.Configuration;
import io.jaegertracing.spi.Sender;
import io.jaegertracing.spi.SenderFactory;
import io.jaegertracing.thrift.internal.senders.HttpSender;
import io.jaegertracing.thrift.internal.senders.UdpSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftSenderFactory
implements SenderFactory {
    private static final Logger log = LoggerFactory.getLogger(ThriftSenderFactory.class);

    public Sender getSender(Configuration.SenderConfiguration conf) {
        if (null != conf.getEndpoint() && !conf.getEndpoint().isEmpty()) {
            HttpSender.Builder httpSenderBuilder = new HttpSender.Builder(conf.getEndpoint());
            if (null != conf.getAuthUsername() && !conf.getAuthUsername().isEmpty() && null != conf.getAuthPassword() && !conf.getAuthPassword().isEmpty()) {
                log.debug("Using HTTP Basic authentication with data from the environment variables.");
                httpSenderBuilder.withAuth(conf.getAuthUsername(), conf.getAuthPassword());
            } else if (null != conf.getAuthToken() && !conf.getAuthToken().isEmpty()) {
                log.debug("Auth Token environment variable found.");
                httpSenderBuilder.withAuth(conf.getAuthToken());
            }
            log.debug("Using the HTTP Sender to send spans directly to the endpoint.");
            return httpSenderBuilder.build();
        }
        log.debug("Using the UDP Sender to send spans to the agent.");
        return new UdpSender(ThriftSenderFactory.stringOrDefault(conf.getAgentHost(), "localhost"), ThriftSenderFactory.numberOrDefault(conf.getAgentPort(), 6831).intValue(), 0);
    }

    public String getType() {
        return "thrift";
    }

    private static String stringOrDefault(String value, String defaultValue) {
        return value != null && value.length() > 0 ? value : defaultValue;
    }

    private static Number numberOrDefault(Number value, Number defaultValue) {
        return value != null ? (Number)value : (Number)defaultValue;
    }

    public String toString() {
        return "ThriftSenderFactory()";
    }
}

