/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import com.carrotsearch.randomizedtesting.AssertingRandom;
import com.carrotsearch.randomizedtesting.MurmurHash3;
import java.util.Random;

public class Xoroshiro128PlusRandom
extends Random {
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private static final float FLOAT_UNIT = 5.9604645E-8f;
    private long s0;
    private long s1;

    public Xoroshiro128PlusRandom(long seed) {
        super(0L);
        this.s0 = MurmurHash3.hash(seed);
        this.s1 = MurmurHash3.hash(this.s0);
        if (this.s0 == 0L && this.s1 == 0L) {
            this.s0 = MurmurHash3.hash(3735928559L);
            this.s1 = MurmurHash3.hash(this.s0);
        }
    }

    @Override
    public void setSeed(long seed) {
        if (this.s0 == 0L && this.s1 == 0L) {
            return;
        }
        throw AssertingRandom.noSetSeed();
    }

    @Override
    public boolean nextBoolean() {
        return this.nextLong() >= 0L;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int i = 0;
        int len = bytes.length;
        while (i < len) {
            long rnd = this.nextInt();
            int n = Math.min(len - i, 8);
            while (n-- > 0) {
                bytes[i++] = (byte)rnd;
                rnd >>>= 8;
            }
        }
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    @Override
    public float nextFloat() {
        return (float)(this.nextInt() >>> 8) * 5.9604645E-8f;
    }

    @Override
    public int nextInt() {
        return (int)this.nextLong();
    }

    @Override
    public int nextInt(int n) {
        return super.nextInt(n);
    }

    @Override
    public double nextGaussian() {
        return super.nextGaussian();
    }

    @Override
    public long nextLong() {
        long s0 = this.s0;
        long s1 = this.s1;
        long result = s0 + s1;
        this.s0 = Long.rotateLeft(s0, 55) ^ (s1 ^= s0) ^ s1 << 14;
        this.s1 = Long.rotateLeft(s1, 36);
        return result;
    }

    @Override
    protected int next(int bits) {
        return (int)this.nextLong() >>> 32 - bits;
    }
}

