/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import com.cloudhopper.commons.util.HexUtil;
import com.cloudhopper.commons.util.StringUtil;
import com.cloudhopper.commons.util.codec.Base64Codec;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Hasher {
    private static final String ALGORITHM_MD5 = "MD5";
    private static final String ALGORITHM_SHA1 = "SHA-1";
    private static final String ALGORITHM_SHA256 = "SHA-256";
    private static final String ALGORITHM_SHA512 = "SHA-512";
    private Algorithm algorithm;

    public Hasher() {
        this.algorithm = Algorithm.MD5;
    }

    public Hasher(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public String toHashedHexString(String string0) throws NoSuchAlgorithmException {
        return this.toHashedHexString(StringUtil.getAsciiBytes(string0));
    }

    public String toHashedHexString(byte[] bytes) throws NoSuchAlgorithmException {
        return HexUtil.toHexString(this.toHashedBytes(bytes));
    }

    public String toHashedBase64String(String string0) throws NoSuchAlgorithmException {
        return this.toHashedBase64String(StringUtil.getAsciiBytes(string0));
    }

    public String toHashedBase64String(byte[] bytes) throws NoSuchAlgorithmException {
        byte[] hashedBytes = this.toHashedBytes(bytes);
        return Base64Codec.encode(hashedBytes);
    }

    public byte[] toHashedBytes(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(this.algorithm.toString());
        return messageDigest.digest(bytes);
    }

    public static enum Algorithm {
        MD5("MD5"),
        SHA1("SHA-1"),
        SHA256("SHA-256"),
        SHA512("SHA-512");

        private final String algorithm;

        private Algorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public String toString() {
            return this.algorithm;
        }
    }
}

