/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class EgtsProtocolDecoder
extends BaseProtocolDecoder {
    public static final int PT_RESPONSE = 0;
    public static final int PT_APPDATA = 1;
    public static final int PT_SIGNED_APPDATA = 2;
    public static final int SERVICE_AUTH = 1;
    public static final int SERVICE_TELEDATA = 2;
    public static final int SERVICE_COMMANDS = 4;
    public static final int SERVICE_FIRMWARE = 9;
    public static final int SERVICE_ECALL = 10;
    public static final int MSG_RECORD_RESPONSE = 0;
    public static final int MSG_TERM_IDENTITY = 1;
    public static final int MSG_MODULE_DATA = 2;
    public static final int MSG_VEHICLE_DATA = 3;
    public static final int MSG_AUTH_PARAMS = 4;
    public static final int MSG_AUTH_INFO = 5;
    public static final int MSG_SERVICE_INFO = 6;
    public static final int MSG_RESULT_CODE = 7;
    public static final int MSG_POS_DATA = 16;
    public static final int MSG_EXT_POS_DATA = 17;
    public static final int MSG_AD_SENSORS_DATA = 18;
    public static final int MSG_COUNTERS_DATA = 19;
    public static final int MSG_STATE_DATA = 20;
    public static final int MSG_LOOPIN_DATA = 22;
    public static final int MSG_ABS_DIG_SENS_DATA = 23;
    public static final int MSG_ABS_AN_SENS_DATA = 24;
    public static final int MSG_ABS_CNTR_DATA = 25;
    public static final int MSG_ABS_LOOPIN_DATA = 26;
    public static final int MSG_LIQUID_LEVEL_SENSOR = 27;
    public static final int MSG_PASSENGERS_COUNTERS = 28;
    private int packetId;

    public EgtsProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, int packetType, int index, int serviceType, int type, ByteBuf content) {
        if (channel != null) {
            ByteBuf data = Unpooled.buffer();
            data.writeByte(type);
            data.writeShortLE(content.readableBytes());
            data.writeBytes(content);
            content.release();
            ByteBuf record = Unpooled.buffer();
            if (packetType == 0) {
                record.writeShortLE(index);
                record.writeByte(0);
            }
            record.writeShortLE(data.readableBytes());
            record.writeShortLE(0);
            record.writeByte(0);
            record.writeByte(serviceType);
            record.writeByte(serviceType);
            record.writeBytes(data);
            data.release();
            int recordChecksum = Checksum.crc16(Checksum.CRC16_CCITT_FALSE, record.nioBuffer());
            ByteBuf response = Unpooled.buffer();
            response.writeByte(1);
            response.writeByte(0);
            response.writeByte(0);
            response.writeByte(11);
            response.writeByte(0);
            response.writeShortLE(record.readableBytes());
            response.writeShortLE(this.packetId++);
            response.writeByte(packetType);
            response.writeByte(Checksum.crc8(Checksum.CRC8_EGTS, response.nioBuffer()));
            response.writeBytes(record);
            record.release();
            response.writeShortLE(recordChecksum);
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        int index = buf.getUnsignedShort(buf.readerIndex() + 5 + 2);
        buf.skipBytes((int)buf.getUnsignedByte(buf.readerIndex() + 3));
        LinkedList<Position> positions = new LinkedList<Position>();
        while (buf.readableBytes() > 2) {
            int length = buf.readUnsignedShortLE();
            int recordIndex = buf.readUnsignedShortLE();
            short recordFlags = buf.readUnsignedByte();
            if (BitUtil.check(recordFlags, 0)) {
                buf.readUnsignedIntLE();
            }
            if (BitUtil.check(recordFlags, 1)) {
                buf.readUnsignedIntLE();
            }
            if (BitUtil.check(recordFlags, 2)) {
                buf.readUnsignedIntLE();
            }
            short serviceType = buf.readUnsignedByte();
            buf.readUnsignedByte();
            int recordEnd = buf.readerIndex() + length;
            Position position = new Position(this.getProtocolName());
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession != null) {
                position.setDeviceId(deviceSession.getDeviceId());
            }
            ByteBuf response = Unpooled.buffer();
            response.writeShortLE(recordIndex);
            response.writeByte(0);
            this.sendResponse(channel, 0, index, serviceType, 0, response);
            while (buf.readerIndex() < recordEnd) {
                short flags;
                short type = buf.readUnsignedByte();
                int end = buf.readUnsignedShortLE() + buf.readerIndex();
                if (type == 1) {
                    buf.readUnsignedIntLE();
                    flags = buf.readUnsignedByte();
                    if (BitUtil.check(flags, 0)) {
                        buf.readUnsignedShortLE();
                    }
                    if (BitUtil.check(flags, 1)) {
                        this.getDeviceSession(channel, remoteAddress, buf.readSlice(15).toString(StandardCharsets.US_ASCII).trim());
                    }
                    if (BitUtil.check(flags, 2)) {
                        this.getDeviceSession(channel, remoteAddress, buf.readSlice(16).toString(StandardCharsets.US_ASCII).trim());
                    }
                    if (BitUtil.check(flags, 3)) {
                        buf.skipBytes(3);
                    }
                    if (BitUtil.check(flags, 5)) {
                        buf.skipBytes(3);
                    }
                    if (BitUtil.check(flags, 6)) {
                        buf.readUnsignedShortLE();
                    }
                    if (BitUtil.check(flags, 7)) {
                        this.getDeviceSession(channel, remoteAddress, buf.readSlice(15).toString(StandardCharsets.US_ASCII).trim());
                    }
                    response = Unpooled.buffer();
                    response.writeByte(0);
                    this.sendResponse(channel, 1, 0, serviceType, 7, response);
                } else if (type == 16) {
                    position.setTime(new Date((buf.readUnsignedIntLE() + 1262304000L) * 1000L));
                    position.setLatitude((double)buf.readUnsignedIntLE() * 90.0 / 4.294967295E9);
                    position.setLongitude((double)buf.readUnsignedIntLE() * 180.0 / 4.294967295E9);
                    flags = buf.readUnsignedByte();
                    position.setValid(BitUtil.check(flags, 0));
                    if (BitUtil.check(flags, 5)) {
                        position.setLatitude(-position.getLatitude());
                    }
                    if (BitUtil.check(flags, 6)) {
                        position.setLongitude(-position.getLongitude());
                    }
                    int speed = buf.readUnsignedShortLE();
                    position.setSpeed(UnitsConverter.knotsFromKph((double)BitUtil.to(speed, 14) * 0.1));
                    position.setCourse(buf.readUnsignedByte() + (BitUtil.check(speed, 15) ? 256 : 0));
                    position.set("odometer", buf.readUnsignedMediumLE() * 100);
                    position.set("input", buf.readUnsignedByte());
                    position.set("event", buf.readUnsignedByte());
                    if (BitUtil.check(flags, 7)) {
                        position.setAltitude(buf.readMediumLE());
                    }
                } else if (type == 17) {
                    flags = buf.readUnsignedByte();
                    if (BitUtil.check(flags, 0)) {
                        position.set("vdop", buf.readUnsignedShortLE());
                    }
                    if (BitUtil.check(flags, 1)) {
                        position.set("hdop", buf.readUnsignedShortLE());
                    }
                    if (BitUtil.check(flags, 2)) {
                        position.set("pdop", buf.readUnsignedShortLE());
                    }
                    if (BitUtil.check(flags, 3)) {
                        position.set("sat", buf.readUnsignedByte());
                    }
                } else if (type == 18) {
                    buf.readUnsignedByte();
                    position.set("output", buf.readUnsignedByte());
                    buf.readUnsignedByte();
                }
                buf.readerIndex(end);
            }
            if (serviceType != 2 || deviceSession == null) continue;
            positions.add(position);
        }
        return positions.isEmpty() ? null : positions;
    }
}

