/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import org.traccar.BaseProtocolEncoder;
import org.traccar.model.Command;
import org.traccar.protocol.Xrb28ProtocolDecoder;

public class Xrb28ProtocolEncoder
extends BaseProtocolEncoder {
    private String formatCommand(Command command, String content) {
        return String.format("\u00ff\u00ff*SCOS,OM,%s,%s#\n", this.getUniqueId(command.getDeviceId()), content);
    }

    @Override
    protected Object encodeCommand(Channel channel, Command command) {
        switch (command.getType()) {
            case "custom": {
                return this.formatCommand(command, command.getString("data"));
            }
            case "positionSingle": {
                return this.formatCommand(command, "D0");
            }
            case "positionPeriodic": {
                return this.formatCommand(command, "D1," + command.getInteger("frequency"));
            }
            case "engineStop": 
            case "alarmDisarm": {
                Xrb28ProtocolDecoder decoder;
                if (channel != null && (decoder = (Xrb28ProtocolDecoder)channel.pipeline().get(Xrb28ProtocolDecoder.class)) != null) {
                    decoder.setPendingCommand(command.getType());
                }
                return this.formatCommand(command, "R0,0,20,1234," + System.currentTimeMillis() / 1000L);
            }
        }
        return null;
    }
}

