/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.WeakEventHandler;
import com.sun.javafx.scene.control.behavior.TreeViewBehavior;
import com.sun.javafx.scene.control.skin.VirtualContainerBase;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import java.lang.ref.WeakReference;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class TreeViewSkin<T>
extends VirtualContainerBase<TreeView<T>, TreeViewBehavior<T>, TreeCell<T>> {
    private boolean needItemCountUpdate = false;
    private boolean needCellsRecreated = false;
    private EventHandler<TreeItem.TreeModificationEvent> rootListener = new EventHandler<TreeItem.TreeModificationEvent>(){

        @Override
        public void handle(TreeItem.TreeModificationEvent treeModificationEvent) {
            if (treeModificationEvent.wasAdded() && treeModificationEvent.wasRemoved() && treeModificationEvent.getAddedSize() == treeModificationEvent.getRemovedSize()) {
                TreeViewSkin.this.needItemCountUpdate = true;
                TreeViewSkin.this.requestLayout();
            } else if (treeModificationEvent.wasAdded() && treeModificationEvent.getAddedSize() == treeModificationEvent.getTreeItem().getChildren().size() || treeModificationEvent.wasRemoved() && treeModificationEvent.getTreeItem().getChildren().isEmpty()) {
                TreeViewSkin.this.needCellsRecreated = true;
                TreeViewSkin.this.requestLayout();
            } else if (treeModificationEvent.getEventType().equals(TreeItem.valueChangedEvent())) {
                TreeViewSkin.this.needCellsRecreated = true;
                TreeViewSkin.this.requestLayout();
            } else {
                for (EventType<? extends Event> eventType = treeModificationEvent.getEventType(); eventType != null; eventType = eventType.getSuperType()) {
                    if (!eventType.equals(TreeItem.treeItemCountChangeEvent())) continue;
                    TreeViewSkin.this.needItemCountUpdate = true;
                    TreeViewSkin.this.requestLayout();
                    break;
                }
            }
        }
    };
    private WeakEventHandler weakRootListener;
    private WeakReference<TreeItem> weakRoot;

    public TreeViewSkin(final TreeView treeView) {
        super(treeView, new TreeViewBehavior(treeView));
        this.flow.setPannable(false);
        this.flow.setFocusTraversable(((TreeView)this.getSkinnable()).isFocusTraversable());
        this.flow.setCreateCell((Callback<VirtualFlow, ? extends IndexedCell>)new Callback<VirtualFlow, TreeCell>(){

            @Override
            public TreeCell call(VirtualFlow virtualFlow) {
                return TreeViewSkin.this.createCell();
            }
        });
        this.getChildren().add(this.flow);
        this.setRoot(((TreeView)this.getSkinnable()).getRoot());
        EventHandler<MouseEvent> eventHandler = new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (treeView.getEditingItem() != null) {
                    treeView.edit(null);
                }
                treeView.requestFocus();
            }
        };
        this.flow.getVbar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        this.flow.getHbar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        ((TreeViewBehavior)this.getBehavior()).setOnFocusPreviousRow(new Runnable(){

            @Override
            public void run() {
                TreeViewSkin.this.onFocusPreviousCell();
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnFocusNextRow(new Runnable(){

            @Override
            public void run() {
                TreeViewSkin.this.onFocusNextCell();
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnMoveToFirstCell(new Runnable(){

            @Override
            public void run() {
                TreeViewSkin.this.onMoveToFirstCell();
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnMoveToLastCell(new Runnable(){

            @Override
            public void run() {
                TreeViewSkin.this.onMoveToLastCell();
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnScrollPageDown(new Callback<Integer, Integer>(){

            @Override
            public Integer call(Integer n) {
                return TreeViewSkin.this.onScrollPageDown(n);
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnScrollPageUp(new Callback<Integer, Integer>(){

            @Override
            public Integer call(Integer n) {
                return TreeViewSkin.this.onScrollPageUp(n);
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnSelectPreviousRow(new Runnable(){

            @Override
            public void run() {
                TreeViewSkin.this.onSelectPreviousCell();
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnSelectNextRow(new Runnable(){

            @Override
            public void run() {
                TreeViewSkin.this.onSelectNextCell();
            }
        });
        this.registerChangeListener(treeView.rootProperty(), "ROOT");
        this.registerChangeListener(treeView.showRootProperty(), "SHOW_ROOT");
        this.registerChangeListener(treeView.cellFactoryProperty(), "CELL_FACTORY");
        this.registerChangeListener(treeView.impl_treeItemCountProperty(), "TREE_ITEM_COUNT");
        this.registerChangeListener(treeView.focusTraversableProperty(), "FOCUS_TRAVERSABLE");
        this.updateItemCount();
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "ROOT") {
            this.setRoot(((TreeView)this.getSkinnable()).getRoot());
        } else if (string == "SHOW_ROOT") {
            if (!((TreeView)this.getSkinnable()).isShowRoot() && this.getRoot() != null) {
                this.getRoot().setExpanded(true);
                this.updateItemCount();
            }
        } else if (string == "CELL_FACTORY") {
            this.flow.recreateCells();
        } else if (string == "TREE_ITEM_COUNT") {
            this.updateItemCount();
        } else if (string == "FOCUS_TRAVERSABLE") {
            this.flow.setFocusTraversable(((TreeView)this.getSkinnable()).isFocusTraversable());
        }
    }

    private TreeItem getRoot() {
        return this.weakRoot == null ? null : (TreeItem)this.weakRoot.get();
    }

    private void setRoot(TreeItem treeItem) {
        if (this.getRoot() != null && this.weakRootListener != null) {
            this.getRoot().removeEventHandler(TreeItem.treeNotificationEvent(), this.weakRootListener);
        }
        this.weakRoot = new WeakReference<TreeItem>(treeItem);
        if (this.getRoot() != null) {
            this.weakRootListener = new WeakEventHandler<TreeItem.TreeModificationEvent>(this.getRoot(), TreeItem.treeNotificationEvent(), this.rootListener);
            this.getRoot().addEventHandler(TreeItem.treeNotificationEvent(), this.weakRootListener);
        }
    }

    @Override
    public int getItemCount() {
        return ((TreeView)this.getSkinnable()).impl_getTreeItemCount();
    }

    private void updateItemCount() {
        int n;
        for (n = 0; n < this.flow.cells.size(); ++n) {
            ((TreeCell)this.flow.cells.get(n)).updateTreeView(null);
        }
        n = this.flow.getCellCount();
        int n2 = this.getItemCount();
        this.flow.setCellCount(n2);
        this.flow.recreateCells();
    }

    @Override
    public TreeCell<T> createCell() {
        TreeCell<T> treeCell = ((TreeView)this.getSkinnable()).getCellFactory() != null ? ((TreeView)this.getSkinnable()).getCellFactory().call(this.getSkinnable()) : this.createDefaultCellImpl();
        if (treeCell.getDisclosureNode() == null) {
            StackPane stackPane = new StackPane();
            stackPane.getStyleClass().setAll((String[])new String[]{"tree-disclosure-node"});
            StackPane stackPane2 = new StackPane();
            stackPane2.getStyleClass().setAll((String[])new String[]{"arrow"});
            stackPane.getChildren().add(stackPane2);
            treeCell.setDisclosureNode(stackPane);
        }
        treeCell.updateTreeView((TreeView)this.getSkinnable());
        return treeCell;
    }

    private TreeCell<T> createDefaultCellImpl() {
        return new TreeCell(){
            private HBox hbox;

            @Override
            public void updateItem(Object object, boolean bl) {
                super.updateItem(object, bl);
                if (object == null || bl) {
                    this.hbox = null;
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    TreeItem treeItem = this.getTreeItem();
                    if (treeItem != null && treeItem.getGraphic() != null) {
                        if (object instanceof Node) {
                            this.setText(null);
                            if (this.hbox == null) {
                                this.hbox = new HBox(3.0);
                            }
                            this.hbox.getChildren().setAll((Node[])new Node[]{treeItem.getGraphic(), (Node)object});
                            this.setGraphic(this.hbox);
                        } else {
                            this.hbox = null;
                            this.setText(object.toString());
                            this.setGraphic(treeItem.getGraphic());
                        }
                    } else {
                        this.hbox = null;
                        if (object instanceof Node) {
                            this.setText(null);
                            this.setGraphic((Node)object);
                        } else {
                            this.setText(object.toString());
                            this.setGraphic(null);
                        }
                    }
                }
            }
        };
    }

    @Override
    protected double computePrefWidth(double d) {
        return this.computePrefHeight(-1.0) * 0.618033987;
    }

    @Override
    protected double computePrefHeight(double d) {
        return 400.0;
    }

    @Override
    protected void layoutChildren() {
        if (this.needCellsRecreated) {
            this.flow.recreateCells();
            this.needCellsRecreated = false;
        } else if (this.needItemCountUpdate) {
            this.updateItemCount();
            this.needItemCountUpdate = false;
        }
        super.layoutChildren();
    }

    private void onFocusPreviousCell() {
        FocusModel focusModel = ((TreeView)this.getSkinnable()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        this.flow.show(focusModel.getFocusedIndex());
    }

    private void onFocusNextCell() {
        FocusModel focusModel = ((TreeView)this.getSkinnable()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        this.flow.show(focusModel.getFocusedIndex());
    }

    private void onSelectPreviousCell() {
        int n = ((TreeView)this.getSkinnable()).getSelectionModel().getSelectedIndex();
        this.flow.show(n);
    }

    private void onSelectNextCell() {
        int n = ((TreeView)this.getSkinnable()).getSelectionModel().getSelectedIndex();
        this.flow.show(n);
    }

    private void onMoveToFirstCell() {
        this.flow.show(0);
        this.flow.setPosition(0.0);
    }

    private void onMoveToLastCell() {
        this.flow.show(this.getItemCount());
        this.flow.setPosition(1.0);
    }

    public int onScrollPageDown(int n) {
        IndexedCell indexedCell = this.flow.getLastVisibleCellWithinViewPort();
        if (indexedCell == null) {
            return -1;
        }
        int n2 = -1;
        int n3 = indexedCell.getIndex();
        if (!indexedCell.isSelected() && !indexedCell.isFocused() || n3 != n) {
            n2 = indexedCell.getIndex();
        } else {
            this.flow.showAsFirst(indexedCell);
            indexedCell = this.flow.getLastVisibleCellWithinViewPort();
            n2 = indexedCell.getIndex();
        }
        this.flow.show(indexedCell);
        return n2;
    }

    public int onScrollPageUp(int n) {
        IndexedCell indexedCell = this.flow.getFirstVisibleCellWithinViewPort();
        if (indexedCell == null) {
            return -1;
        }
        int n2 = -1;
        int n3 = indexedCell.getIndex();
        if (!indexedCell.isSelected() && !indexedCell.isFocused() || n3 != n) {
            n2 = indexedCell.getIndex();
        } else {
            this.flow.showAsLast(indexedCell);
            indexedCell = this.flow.getFirstVisibleCellWithinViewPort();
            n2 = indexedCell.getIndex();
        }
        this.flow.show(indexedCell);
        return n2;
    }
}

