/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.xnet.hba;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.activeio.xnet.ServerService;
import org.apache.activeio.xnet.ServiceException;
import org.apache.activeio.xnet.hba.ExactIPAddressPermission;
import org.apache.activeio.xnet.hba.ExactIPv6AddressPermission;
import org.apache.activeio.xnet.hba.IPAddressPermission;
import org.apache.activeio.xnet.hba.IPAddressPermissionFactory;

public class ServiceAccessController
implements ServerService {
    private final ServerService next;
    private IPAddressPermission[] allowHosts;

    public ServiceAccessController(ServerService next) {
        this.next = next;
    }

    public ServiceAccessController(String name, ServerService next, IPAddressPermission[] ipAddressMasks) {
        this.next = next;
        this.allowHosts = ipAddressMasks;
    }

    public void service(Socket socket) throws ServiceException, IOException {
        this.checkHostsAuthorization(socket.getInetAddress(), socket.getLocalAddress());
        this.next.service(socket);
    }

    public IPAddressPermission[] getAllowHosts() {
        return this.allowHosts;
    }

    public void setAllowHosts(IPAddressPermission[] ipAddressMasks) {
        this.allowHosts = ipAddressMasks;
    }

    public void checkHostsAuthorization(InetAddress clientAddress, InetAddress serverAddress) throws SecurityException {
        if (clientAddress.equals(serverAddress)) {
            return;
        }
        for (int i = 0; i < this.allowHosts.length; ++i) {
            if (!this.allowHosts[i].implies(clientAddress)) continue;
            return;
        }
        throw new SecurityException("Host " + clientAddress.getHostAddress() + " is not authorized to access this service.");
    }

    private void parseAdminIPs(Properties props) throws ServiceException {
        LinkedList<IPAddressPermission> ipAddressMasksList = new LinkedList<IPAddressPermission>();
        try {
            InetAddress[] localIps = InetAddress.getAllByName("localhost");
            for (int i = 0; i < localIps.length; ++i) {
                if (localIps[i] instanceof Inet4Address) {
                    ipAddressMasksList.add(new ExactIPAddressPermission(localIps[i].getAddress()));
                    continue;
                }
                ipAddressMasksList.add(new ExactIPv6AddressPermission(localIps[i].getAddress()));
            }
        }
        catch (UnknownHostException e) {
            throw new ServiceException("Could not get localhost inet address", e);
        }
        String ipString = props.getProperty("only_from");
        if (ipString != null) {
            StringTokenizer st = new StringTokenizer(ipString, " ");
            while (st.hasMoreTokens()) {
                String mask = st.nextToken();
                ipAddressMasksList.add(IPAddressPermissionFactory.getIPAddressMask(mask));
            }
        }
        this.allowHosts = ipAddressMasksList.toArray(new IPAddressPermission[ipAddressMasksList.size()]);
    }

    public void init(Properties props) throws Exception {
        this.parseAdminIPs(props);
        this.next.init(props);
    }

    public void start() throws ServiceException {
        this.next.start();
    }

    public void stop() throws ServiceException {
        this.next.stop();
    }

    public String getName() {
        return this.next.getName();
    }

    public String getIP() {
        return this.next.getIP();
    }

    public int getPort() {
        return this.next.getPort();
    }
}

