/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.directvm.DirectVmEndpoint;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectVmProcessor
extends DelegateAsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DirectVmProcessor.class);
    private final DirectVmEndpoint endpoint;

    public DirectVmProcessor(Processor processor, DirectVmEndpoint endpoint) {
        super(processor);
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        final Exchange copy = this.prepareExchange(exchange);
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        boolean changed2 = false;
        try {
            ClassLoader appClassLoader = this.endpoint.getCamelContext().getApplicationContextClassLoader();
            if (appClassLoader != null) {
                LOG.trace("Setting Thread ContextClassLoader to {}", (Object)appClassLoader);
                Thread.currentThread().setContextClassLoader(appClassLoader);
                changed2 = true;
            }
            boolean bl = this.processor.process(copy, new AsyncCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void done(boolean done) {
                    try {
                        ExchangeHelper.copyResults(exchange, copy);
                    }
                    finally {
                        callback.done(done);
                    }
                }
            });
            return bl;
        }
        finally {
            if (changed2) {
                LOG.trace("Restoring Thread ContextClassLoader to {}", (Object)current);
                Thread.currentThread().setContextClassLoader(current);
            }
        }
    }

    protected Exchange prepareExchange(Exchange exchange) {
        Exchange newExchange = ExchangeHelper.copyExchangeAndSetCamelContext(exchange, this.endpoint.getCamelContext(), false);
        newExchange.setFromEndpoint(this.endpoint);
        return newExchange;
    }

    @Override
    public String toString() {
        return "DirectVm[" + this.processor + "]";
    }
}

