/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.Olap4jDataSource;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class SPDataSource
implements Comparable<SPDataSource> {
    private static final Logger logger = Logger.getLogger(SPDataSource.class);
    public static final String PL_LOGICAL = "Logical";
    public static final String BUILTIN = "builtin:";
    private Map<String, String> properties;
    private final DataSourceCollection<SPDataSource> parentCollection;
    private transient PropertyChangeSupport pcs;
    public static final String SERVER = "server:";

    public static String getUserFriendlyName(Class<? extends SPDataSource> dsType) {
        if (dsType.equals(JDBCDataSource.class)) {
            return "Database connection";
        }
        if (dsType.equals(Olap4jDataSource.class)) {
            return "OLAP connection";
        }
        return dsType.getSimpleName();
    }

    private PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public SPDataSource(DataSourceCollection<SPDataSource> parentCollection) {
        this.properties = new LinkedHashMap<String, String>();
        this.parentCollection = parentCollection;
    }

    public SPDataSource(SPDataSource copyMe) {
        this.properties = new LinkedHashMap<String, String>(copyMe.properties);
        this.parentCollection = copyMe.parentCollection;
    }

    protected String putImpl(String key, String value, String propertyName) {
        String oldValue = this.get(key);
        this.properties.put(key, value);
        this.getPcs().firePropertyChange(propertyName, oldValue, value);
        return oldValue;
    }

    public String put(String key, String value) {
        return this.putImpl(key, value, key);
    }

    public String get(String key) {
        return this.properties.get(key);
    }

    public Map<String, String> getPropertiesMap() {
        return Collections.unmodifiableMap(this.properties);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SPDataSource)) {
            return false;
        }
        SPDataSource other = (SPDataSource)o;
        return ((Object)this.properties).equals(other.properties);
    }

    public int hashCode() {
        return ((Object)this.properties).hashCode();
    }

    @Override
    public final int compareTo(SPDataSource ds2) {
        if (this == ds2) {
            return 0;
        }
        String v1 = this.getName();
        String v2 = ds2.getName();
        if (v1 == null && v2 != null) {
            return -1;
        }
        if (v1 != null && v2 == null) {
            return 1;
        }
        int tmp = v1 != null && v2 != null ? v1.compareToIgnoreCase(v2) : 0;
        return tmp;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().removePropertyChangeListener(l);
    }

    public List<PropertyChangeListener> getPropertyChangeListeners() {
        return Collections.unmodifiableList(Arrays.asList(this.pcs.getPropertyChangeListeners()));
    }

    public void copyFrom(SPDataSource dbcs) {
        this.properties.clear();
        this.setName(dbcs.getName());
        for (Map.Entry<String, String> entry : dbcs.getPropertiesMap().entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public DataSourceCollection<SPDataSource> getParentCollection() {
        return this.parentCollection;
    }

    public String getName() {
        return this.get(PL_LOGICAL);
    }

    public void setName(String argName) {
        this.putImpl(PL_LOGICAL, argName, "name");
    }

    public String getDisplayName() {
        return this.get(PL_LOGICAL);
    }

    public void setDisplayName(String argDisplayName) {
        this.putImpl(PL_LOGICAL, argDisplayName, "name");
    }
}

