/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.security.Key;
import java.util.ArrayList;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.processor.DerivedKeyTokenProcessor;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.SAMLTokenProcessor;
import org.apache.ws.security.processor.X509Util;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReferenceListProcessor
implements Processor {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$processor$ReferenceListProcessor == null ? (class$org$apache$ws$security$processor$ReferenceListProcessor = ReferenceListProcessor.class$("org.apache.ws.security.processor.ReferenceListProcessor")) : class$org$apache$ws$security$processor$ReferenceListProcessor).getName());
    private boolean debug = false;
    WSDocInfo wsDocInfo = null;
    static /* synthetic */ Class class$org$apache$ws$security$processor$ReferenceListProcessor;

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wdi, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        this.debug = log.isDebugEnabled();
        if (this.debug) {
            log.debug((Object)"Found reference list element");
        }
        if (cb == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        this.wsDocInfo = wdi;
        ArrayList uris = this.handleReferenceList(elem, cb, crypto);
        returnResults.add(0, new WSSecurityEngineResult(4, uris));
    }

    private ArrayList handleReferenceList(Element elem, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        Document doc = elem.getOwnerDocument();
        Node tmpE = null;
        ArrayList<String> dataRefUris = new ArrayList<String>();
        for (tmpE = elem.getFirstChild(); tmpE != null; tmpE = tmpE.getNextSibling()) {
            if (tmpE.getNodeType() != 1 || !tmpE.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#") || !tmpE.getLocalName().equals("DataReference")) continue;
            String dataRefURI = ((Element)tmpE).getAttribute("URI");
            this.decryptDataRefEmbedded(doc, dataRefURI, cb, crypto);
            dataRefUris.add(dataRefURI.substring(1));
        }
        return dataRefUris;
    }

    public void decryptDataRefEmbedded(Document doc, String dataRefURI, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found data reference: " + dataRefURI));
        }
        Element encBodyData = null;
        encBodyData = WSSecurityUtil.getElementByWsuId(doc, dataRefURI);
        if (encBodyData == null) {
            encBodyData = WSSecurityUtil.getElementByGenId(doc, dataRefURI);
        }
        if (encBodyData == null) {
            throw new WSSecurityException(3, "dataRef", new Object[]{dataRefURI});
        }
        boolean content = X509Util.isContent(encBodyData);
        String symEncAlgo = X509Util.getEncAlgo(encBodyData);
        Element tmpE = (Element)WSSecurityUtil.findElement(encBodyData, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        if (tmpE == null) {
            throw new WSSecurityException(3, "noKeyinfo");
        }
        Element secRefToken = (Element)WSSecurityUtil.getDirectChild(tmpE, "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SecretKey symmetricKey = null;
        symmetricKey = secRefToken == null ? X509Util.getSharedKey(tmpE, symEncAlgo, cb) : this.getKeyFromReference(secRefToken, symEncAlgo, crypto, cb);
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)symEncAlgo);
            xmlCipher.init(2, (Key)symmetricKey);
        }
        catch (XMLEncryptionException e1) {
            throw new WSSecurityException(2, null, null, e1);
        }
        if (content) {
            encBodyData = (Element)encBodyData.getParentNode();
        }
        try {
            xmlCipher.doFinal(doc, encBodyData, content);
        }
        catch (Exception e) {
            throw new WSSecurityException(8, null, null, e);
        }
    }

    public String getId() {
        return null;
    }

    private SecretKey getKeyFromReference(Element secRefToken, String algorithm, Crypto crypto, CallbackHandler cb) throws WSSecurityException {
        SecurityTokenReference secRef = new SecurityTokenReference(secRefToken);
        byte[] decryptedData = null;
        if (secRef.containsReference()) {
            Reference reference = secRef.getReference();
            String uri = reference.getURI();
            String id = uri.substring(1);
            Processor p = this.wsDocInfo.getProcessor(id);
            if (p == null || !(p instanceof EncryptedKeyProcessor) && !(p instanceof DerivedKeyTokenProcessor) && !(p instanceof SAMLTokenProcessor)) {
                WSPasswordCallback pwcb = new WSPasswordCallback(id, 7);
                try {
                    cb.handle(new Callback[]{pwcb});
                }
                catch (Exception e) {
                    throw new WSSecurityException(0, "noPassword", new Object[]{id});
                }
                decryptedData = pwcb.getKey();
                if (decryptedData == null) {
                    throw new WSSecurityException(8, "unsupportedKeyId");
                }
            }
            if (p instanceof EncryptedKeyProcessor) {
                EncryptedKeyProcessor ekp = (EncryptedKeyProcessor)p;
                decryptedData = ekp.getDecryptedBytes();
            } else if (p instanceof DerivedKeyTokenProcessor) {
                DerivedKeyTokenProcessor dkp = (DerivedKeyTokenProcessor)p;
                decryptedData = dkp.getKeyBytes(WSSecurityUtil.getKeyLength(algorithm));
            } else if (p instanceof SAMLTokenProcessor) {
                SAMLTokenProcessor samlp = (SAMLTokenProcessor)p;
                SAMLKeyInfo keyInfo = SAMLUtil.getSAMLKeyInfo(samlp.getSamlTokenElement(), crypto, cb);
                decryptedData = keyInfo.getSecret();
            }
        } else {
            throw new WSSecurityException(8, "noReference");
        }
        return WSSecurityUtil.prepareSecretKey(algorithm, decryptedData);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

