/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.DocIdSetBuilder;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesCollectorQueue;

abstract class SortedDocsProducer {
    protected final String field;

    SortedDocsProducer(String field) {
        this.field = field;
    }

    protected boolean processBucket(final CompositeValuesCollectorQueue queue, LeafReaderContext context, final DocIdSetIterator iterator, Comparable<?> leadSourceBucket, final @Nullable DocIdSetBuilder builder) throws IOException {
        final int[] topCompositeCollected = new int[1];
        final boolean[] hasCollected = new boolean[1];
        LeafBucketCollector queueCollector = new LeafBucketCollector(){
            int lastDoc = -1;
            int remainingBits = (int)Math.min(iterator.cost(), Integer.MAX_VALUE);
            DocIdSetBuilder.BulkAdder adder = builder == null ? null : builder.grow(this.remainingBits);

            @Override
            public void collect(int doc, long bucket) throws IOException {
                hasCollected[0] = true;
                int slot = queue.addIfCompetitive();
                if (slot != -1) {
                    topCompositeCollected[0] = topCompositeCollected[0] + 1;
                    if (this.adder != null && doc != this.lastDoc) {
                        if (this.remainingBits == 0) {
                            this.adder = builder.grow(128);
                            this.remainingBits = 128;
                        }
                        this.adder.add(doc);
                        --this.remainingBits;
                        this.lastDoc = doc;
                    }
                }
            }
        };
        Bits liveDocs = context.reader().getLiveDocs();
        LeafBucketCollector collector = queue.getLeafCollector(leadSourceBucket, context, queueCollector);
        while (iterator.nextDoc() != Integer.MAX_VALUE) {
            if (liveDocs != null && !liveDocs.get(iterator.docID())) continue;
            collector.collect(iterator.docID());
        }
        return queue.isFull() && hasCollected[0] && topCompositeCollected[0] == 0;
    }

    abstract DocIdSet processLeaf(Query var1, CompositeValuesCollectorQueue var2, LeafReaderContext var3, boolean var4) throws IOException;
}

