/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.DataInputOutputUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.util.lang.ClassPath;
import org.jetbrains.kotlin.com.intellij.util.lang.ClasspathCache;
import org.jetbrains.kotlin.com.intellij.util.lang.Loader;
import org.jetbrains.kotlin.com.intellij.util.lang.Resource;

class FileLoader
extends Loader {
    private final File myRootDir;
    private final String myRootDirAbsolutePath;
    private final ClassPath myConfiguration;
    private final DirEntry root = new DirEntry(0, null);
    private static final AtomicInteger totalLoaders = new AtomicInteger();
    private static final AtomicLong totalScanning = new AtomicLong();
    private static final AtomicLong totalSaving = new AtomicLong();
    private static final AtomicLong totalReading = new AtomicLong();
    private static final Boolean doFsActivityLogging = false;

    FileLoader(URL url, int index2, ClassPath configuration) throws IOException {
        super(url, index2);
        try {
            this.myRootDir = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        this.myRootDirAbsolutePath = this.myRootDir.getAbsolutePath();
        this.myConfiguration = configuration;
    }

    private void buildPackageCache(File dir, ClasspathCache.LoaderDataBuilder context) {
        context.addResourcePackageFromName(this.getRelativeResourcePath(dir));
        File[] files2 = dir.listFiles();
        if (files2 == null) {
            return;
        }
        boolean containsClasses = false;
        for (File file2 : files2) {
            boolean isClass = file2.getPath().endsWith(".class");
            if (isClass) {
                if (!containsClasses) {
                    context.addClassPackageFromName(this.getRelativeResourcePath(file2));
                    containsClasses = true;
                }
                context.addPossiblyDuplicateNameEntry(file2.getName());
                continue;
            }
            context.addPossiblyDuplicateNameEntry(file2.getName());
            this.buildPackageCache(file2, context);
        }
    }

    private String getRelativeResourcePath(File file2) {
        return this.getRelativeResourcePath(file2.getAbsolutePath());
    }

    private String getRelativeResourcePath(String absFilePath) {
        String relativePath = absFilePath.substring(this.myRootDirAbsolutePath.length());
        relativePath = (relativePath = relativePath.replace(File.separatorChar, '/')).startsWith("/") ? relativePath.substring(1) : relativePath;
        return relativePath;
    }

    @Override
    @Nullable
    Resource getResource(String name) {
        try {
            URL url;
            if (this.myConfiguration.myLazyClassloadingCaches) {
                DirEntry lastEntry = this.root;
                int prevIndex = 0;
                int nextIndex = name.indexOf(47, prevIndex);
                while (true) {
                    int nameEnd;
                    int nameHash;
                    if (!this.nameHashIsPresentInChildren(lastEntry, name, prevIndex, nameHash = FileLoader.stringHashCodeInsensitive(name, prevIndex, nameEnd = nextIndex == -1 ? name.length() : nextIndex))) {
                        return null;
                    }
                    if (nextIndex == -1 || nextIndex == name.length() - 1) break;
                    lastEntry = FileLoader.findOrCreateNextDirEntry(lastEntry, name, prevIndex, nameEnd, nameHash);
                    prevIndex = nextIndex + 1;
                    nextIndex = name.indexOf(47, prevIndex);
                }
            }
            if (!(url = new URL(this.getBaseURL(), name)).getFile().startsWith(this.getBaseURL().getFile())) {
                return null;
            }
            File file2 = new File(this.myRootDir, name.replace('/', File.separatorChar));
            if (file2.exists()) {
                return new MyResource(url, file2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    private static DirEntry findOrCreateNextDirEntry(DirEntry lastEntry, String name, int prevIndex, int nameEnd, int nameHash) {
        DirEntry nextEntry = null;
        DirEntry[] directories = lastEntry.childrenDirectories;
        if (directories != null) {
            int len = directories.length;
            for (int index2 = 0; index2 < len; ++index2) {
                DirEntry previouslyScannedDir = directories[index2];
                if (previouslyScannedDir.nameHash != nameHash || !previouslyScannedDir.name.regionMatches(0, name, prevIndex, nameEnd - prevIndex)) continue;
                nextEntry = previouslyScannedDir;
                break;
            }
        }
        if (nextEntry == null) {
            DirEntry[] newChildrenDirectories;
            nextEntry = new DirEntry(nameHash, name.substring(prevIndex, nameEnd));
            if (directories != null) {
                newChildrenDirectories = new DirEntry[directories.length + 1];
                System.arraycopy(directories, 0, newChildrenDirectories, 0, directories.length);
                newChildrenDirectories[directories.length] = nextEntry;
            } else {
                newChildrenDirectories = new DirEntry[]{nextEntry};
            }
            lastEntry.childrenDirectories = newChildrenDirectories;
        }
        DirEntry dirEntry = lastEntry = nextEntry;
        if (dirEntry == null) {
            FileLoader.$$$reportNull$$$0(0);
        }
        return dirEntry;
    }

    private boolean nameHashIsPresentInChildren(DirEntry lastEntry, String name, int prevIndex, int nameHash) {
        int[] childrenNameHashes = lastEntry.childrenNameHashes;
        if (childrenNameHashes == null) {
            String[] list2 = (prevIndex != 0 ? new File(this.myRootDir, name.substring(0, prevIndex)) : this.myRootDir).list();
            if (list2 != null) {
                childrenNameHashes = new int[list2.length];
                for (int i = 0; i < list2.length; ++i) {
                    childrenNameHashes[i] = FileLoader.stringHashCodeInsensitive(list2[i], 0, list2[i].length());
                }
            } else {
                childrenNameHashes = DirEntry.empty;
            }
            lastEntry.childrenNameHashes = childrenNameHashes;
        }
        for (int childNameHash : childrenNameHashes) {
            if (childNameHash != nameHash) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClasspathCache.LoaderData tryReadFromIndex() {
        if (!this.myConfiguration.myCanHavePersistentIndex) {
            return null;
        }
        long started = System.nanoTime();
        File index2 = this.getIndexFileFile();
        FilterInputStream reader = null;
        boolean isOk = false;
        try {
            reader = new DataInputStream(new BufferedInputStream(new FileInputStream(index2)));
            if (DataInputOutputUtilRt.readINT((DataInput)((Object)reader)) == 1) {
                ClasspathCache.LoaderData loaderData = new ClasspathCache.LoaderData((DataInput)((Object)reader));
                isOk = true;
                ClasspathCache.LoaderData loaderData2 = loaderData;
                return loaderData2;
            }
        }
        catch (FileNotFoundException ex) {
            isOk = true;
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (!isOk) {
                index2.delete();
            }
            totalReading.addAndGet(System.nanoTime() - started);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySaveToIndex(ClasspathCache.LoaderData data) {
        if (!this.myConfiguration.myCanHavePersistentIndex) {
            return;
        }
        long started = System.nanoTime();
        File index2 = this.getIndexFileFile();
        UnsyncDataOutputStream writer = null;
        boolean isOk = false;
        try {
            writer = new UnsyncDataOutputStream(new BufferedOutputStream(new FileOutputStream(index2)));
            DataInputOutputUtilRt.writeINT(writer, 1);
            data.save(writer);
            isOk = true;
        }
        catch (IOException iOException) {
        }
        finally {
            if (writer != null) {
                try {
                    ((OutputStream)writer).close();
                }
                catch (IOException iOException) {}
            }
            if (!isOk) {
                index2.delete();
            }
            totalSaving.addAndGet(System.nanoTime() - started);
        }
    }

    @NotNull
    private File getIndexFileFile() {
        File file2 = new File(this.myRootDir, "classpath.index");
        if (file2 == null) {
            FileLoader.$$$reportNull$$$0(1);
        }
        return file2;
    }

    @Override
    @NotNull
    public ClasspathCache.LoaderData buildData() {
        long currentScanningTime;
        ClasspathCache.LoaderData loaderData = this.tryReadFromIndex();
        int nsMsFactor = 1000000;
        int currentLoaders = totalLoaders.incrementAndGet();
        if (loaderData == null) {
            long started = System.nanoTime();
            ClasspathCache.LoaderDataBuilder loaderDataBuilder = new ClasspathCache.LoaderDataBuilder();
            this.buildPackageCache(this.myRootDir, loaderDataBuilder);
            loaderData = loaderDataBuilder.build();
            long doneNanos = System.nanoTime() - started;
            currentScanningTime = totalScanning.addAndGet(doneNanos);
            if (doFsActivityLogging.booleanValue()) {
                System.out.println("Scanned: " + this.myRootDirAbsolutePath + " for " + doneNanos / 1000000L + "ms");
            }
            this.trySaveToIndex(loaderData);
        } else {
            currentScanningTime = totalScanning.get();
        }
        if (doFsActivityLogging.booleanValue()) {
            System.out.println("Scanning: " + currentScanningTime / 1000000L + "ms, saving: " + totalSaving.get() / 1000000L + "ms, loading:" + totalReading.get() / 1000000L + "ms for " + currentLoaders + " loaders");
        }
        ClasspathCache.LoaderData loaderData2 = loaderData;
        if (loaderData2 == null) {
            FileLoader.$$$reportNull$$$0(2);
        }
        return loaderData2;
    }

    public String toString() {
        return "FileLoader [" + this.myRootDir + "]";
    }

    private static int stringHashCodeInsensitive(@NotNull String s, int from, int to) {
        if (s == null) {
            FileLoader.$$$reportNull$$$0(3);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtilRt.toLowerCase(s.charAt(off));
        }
        return h;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/lang/FileLoader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateNextDirEntry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexFileFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/lang/FileLoader";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeInsensitive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UnsyncDataOutputStream
    extends DataOutputStream {
        UnsyncDataOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }
    }

    private static class MyResource
    extends Resource {
        private final URL myUrl;
        private final File myFile;

        MyResource(URL url, File file2) {
            this.myUrl = url;
            this.myFile = file2;
        }

        @Override
        public URL getURL() {
            return this.myUrl;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.myFile));
        }

        @Override
        public byte[] getBytes() throws IOException {
            InputStream stream = this.getInputStream();
            try {
                byte[] byArray = FileUtilRt.loadBytes(stream, (int)this.myFile.length());
                return byArray;
            }
            finally {
                stream.close();
            }
        }
    }

    private static class DirEntry {
        static final int[] empty = new int[0];
        volatile int[] childrenNameHashes;
        volatile DirEntry[] childrenDirectories;
        final int nameHash;
        final String name;

        DirEntry(int _nameHash, String _name) {
            this.nameHash = _nameHash;
            this.name = _name;
        }
    }
}

