/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.LegacyMemberNameGenerator;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrFunctionKt;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsScope;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0011H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/LegacyMemberNameGenerator;", "", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsScope;)V", "fieldCache", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "functionCache", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getScope", "()Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "getNameForMemberField", "field", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNewNameForField", "f", "getNewNameForFunction", "declaration", "backend.js"})
public final class LegacyMemberNameGenerator {
    private final Map<IrField, JsName> fieldCache;
    private final Map<IrFunction, JsName> functionCache;
    @NotNull
    private final JsScope scope;

    @NotNull
    public final JsName getNameForMemberField(@NotNull IrField field2) {
        JsName jsName;
        Intrinsics.checkParameterIsNotNull((Object)field2, (String)"field");
        Map<IrField, JsName> $this$getOrPut$iv = this.fieldCache;
        boolean $i$f$getOrPut = false;
        JsName value$iv = $this$getOrPut$iv.get(field2);
        if (value$iv == null) {
            boolean bl = false;
            JsName answer$iv = this.getNewNameForField(field2);
            $this$getOrPut$iv.put(field2, answer$iv);
            jsName = answer$iv;
        } else {
            jsName = value$iv;
        }
        return jsName;
    }

    @NotNull
    public final JsName getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        JsName jsName;
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Map<IrFunction, JsName> $this$getOrPut$iv = this.functionCache;
        boolean $i$f$getOrPut = false;
        JsName value$iv = $this$getOrPut$iv.get(function2);
        if (value$iv == null) {
            boolean bl = false;
            JsName answer$iv = this.getNewNameForFunction(function2);
            $this$getOrPut$iv.put(function2, answer$iv);
            jsName = answer$iv;
        } else {
            jsName = value$iv;
        }
        return jsName;
    }

    private final JsName getNewNameForField(IrField f) {
        boolean bl = !org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isTopLevel(f);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = !f.isStatic();
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (IrUtilsKt.isEffectivelyExternal(f)) {
            JsName jsName = this.scope.declareName(f.getName().getIdentifier());
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"scope.declareName(f.name.identifier)");
            return jsName;
        }
        IrDeclarationParent irDeclarationParent = f.getParent();
        if (irDeclarationParent == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
        }
        String string = ((IrDeclarationWithName)((Object)irDeclarationParent)).getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(f.parent as IrDeclarati\u2026WithName).name.asString()");
        String parentName = string;
        String name = f.getName().asString() + '_' + parentName;
        JsName jsName = this.scope.declareFreshName(NameTablesKt.sanitizeName(name));
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"scope.declareFreshName(sanitizeName(name))");
        return jsName;
    }

    private final JsName getNewNameForFunction(IrSimpleFunction declaration2) {
        boolean bl = !IrFunctionKt.isStaticMethodOfClass(declaration2);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = declaration2.getDispatchReceiverParameter() != null;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = AnnotationUtilsKt.getJsNameOrKotlinName(declaration2).asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"declaration.getJsNameOrKotlinName().asString()");
        String declarationName = string;
        if (Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)JsLoweredDeclarationOrigin.BRIDGE_TO_EXTERNAL_FUNCTION.INSTANCE)) {
            JsName jsName = this.scope.declareName(declarationName);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"scope.declareName(declarationName)");
            return jsName;
        }
        if (IrUtilsKt.isEffectivelyExternal(declaration2)) {
            JsName jsName = this.scope.declareName(declarationName);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"scope.declareName(declarationName)");
            return jsName;
        }
        String string2 = AnnotationUtilsKt.getJsName(declaration2);
        if (string2 != null) {
            String string3 = string2;
            bl3 = false;
            bl4 = false;
            String jsName = string3;
            boolean bl7 = false;
            JsName jsName2 = this.scope.declareName(jsName);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName2, (String)"scope.declareName(jsName)");
            return jsName2;
        }
        StringBuilder nameBuilder = new StringBuilder();
        if (MiscKt.isEqualsInheritedFromAny(declaration2)) {
            JsName jsName = this.scope.declareName("equals");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"scope.declareName(\"equals\")");
            return jsName;
        }
        nameBuilder.append(declarationName);
        Object $this$ifNotEmpty$iv = declaration2.getTypeParameters();
        boolean $i$f$ifNotEmpty = false;
        Collection collection = $this$ifNotEmpty$iv;
        boolean bl7 = false;
        if (!collection.isEmpty()) {
            List $this$ifNotEmpty = (List)$this$ifNotEmpty$iv;
            boolean bl8 = false;
            nameBuilder.append("_$t");
            StringBuilder cfr_ignored_0 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)$this$ifNotEmpty, (Appendable)nameBuilder, (CharSequence)"", null, null, (int)0, null, (Function1)getNewNameForFunction.2.1.INSTANCE, (int)60, null);
        }
        IrValueParameter irValueParameter = declaration2.getExtensionReceiverParameter();
        if (irValueParameter != null) {
            $this$ifNotEmpty$iv = irValueParameter;
            $i$f$ifNotEmpty = false;
            boolean bl9 = false;
            Object it = $this$ifNotEmpty$iv;
            boolean bl10 = false;
            nameBuilder.append("_r$" + IrTypeUtilsKt.asString(it.getType()));
        }
        $this$ifNotEmpty$iv = declaration2.getValueParameters();
        $i$f$ifNotEmpty = false;
        Object object = $this$ifNotEmpty$iv;
        boolean it = false;
        if (!object.isEmpty()) {
            List $this$ifNotEmpty = (List)$this$ifNotEmpty$iv;
            boolean bl11 = false;
            StringBuilder cfr_ignored_1 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)$this$ifNotEmpty, (Appendable)nameBuilder, (CharSequence)"", null, null, (int)0, null, (Function1)getNewNameForFunction.4.1.INSTANCE, (int)60, null);
        }
        IrType irType = declaration2.getReturnType();
        bl4 = false;
        boolean bl12 = false;
        IrType it2 = irType;
        boolean bl13 = false;
        if (InlineClassesKt.isInlined(it2)) {
            nameBuilder.append("_ret$" + IrTypeUtilsKt.asString(it2));
        }
        String string4 = nameBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"nameBuilder.toString()");
        JsName jsName = this.scope.declareName(NameTablesKt.sanitizeName(string4));
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"scope.declareName(saniti\u2026(nameBuilder.toString()))");
        return jsName;
    }

    @NotNull
    public final JsScope getScope() {
        return this.scope;
    }

    public LegacyMemberNameGenerator(@NotNull JsScope scope) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        this.scope = scope;
        LegacyMemberNameGenerator legacyMemberNameGenerator = this;
        boolean bl = false;
        legacyMemberNameGenerator.fieldCache = map2 = (Map)new LinkedHashMap();
        legacyMemberNameGenerator = this;
        bl = false;
        legacyMemberNameGenerator.functionCache = map2 = (Map)new LinkedHashMap();
    }
}

