/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.toolchain;

import java.util.List;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.fingerprint.classpath.ClasspathFingerprinter;
import org.gradle.internal.logging.text.DiagnosticsVisitor;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.play.internal.javascript.GoogleClosureCompiler;
import org.gradle.play.internal.routes.RoutesCompilerAdapterFactory;
import org.gradle.play.internal.toolchain.DefaultPlayToolProvider;
import org.gradle.play.internal.toolchain.PlayToolChainInternal;
import org.gradle.play.internal.toolchain.PlayToolProvider;
import org.gradle.play.internal.twirl.TwirlCompilerAdapterFactory;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.util.CollectionUtils;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.WorkerDaemonFactory;

public class DefaultPlayToolChain
implements PlayToolChainInternal {
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final WorkerDaemonFactory workerDaemonFactory;
    private final ConfigurationContainer configurationContainer;
    private final DependencyHandler dependencyHandler;
    private final WorkerProcessFactory workerProcessBuilderFactory;
    private final WorkerDirectoryProvider workerDirectoryProvider;
    private final ClasspathFingerprinter fingerprinter;
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;

    public DefaultPlayToolChain(JavaForkOptionsFactory forkOptionsFactory, WorkerDaemonFactory workerDaemonFactory, ConfigurationContainer configurationContainer, DependencyHandler dependencyHandler, WorkerProcessFactory workerProcessBuilderFactory, WorkerDirectoryProvider workerDirectoryProvider, ClasspathFingerprinter fingerprinter, ClassPathRegistry classPathRegistry, ClassLoaderRegistry classLoaderRegistry, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        this.forkOptionsFactory = forkOptionsFactory;
        this.workerDaemonFactory = workerDaemonFactory;
        this.configurationContainer = configurationContainer;
        this.dependencyHandler = dependencyHandler;
        this.workerProcessBuilderFactory = workerProcessBuilderFactory;
        this.workerDirectoryProvider = workerDirectoryProvider;
        this.fingerprinter = fingerprinter;
        this.classPathRegistry = classPathRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
    }

    public String getName() {
        return "PlayToolchain";
    }

    public String getDisplayName() {
        return "Default Play Toolchain";
    }

    @Override
    public PlayToolProvider select(PlayPlatform targetPlatform) {
        try {
            Set twirlClasspath = this.resolveToolClasspath(TwirlCompilerAdapterFactory.createAdapter(targetPlatform).getDependencyNotation().toArray()).resolve();
            Set routesClasspath = this.resolveToolClasspath(RoutesCompilerAdapterFactory.createAdapter(targetPlatform).getDependencyNotation()).resolve();
            Set javascriptClasspath = this.resolveToolClasspath(GoogleClosureCompiler.getDependencyNotation()).resolve();
            return new DefaultPlayToolProvider(this.forkOptionsFactory, this.workerDirectoryProvider.getWorkingDirectory(), this.workerDaemonFactory, this.workerProcessBuilderFactory, targetPlatform, twirlClasspath, routesClasspath, javascriptClasspath, this.fingerprinter, this.classPathRegistry, this.classLoaderRegistry, this.actionExecutionSpecFactory);
        }
        catch (ResolveException e) {
            return new UnavailablePlayToolProvider((Exception)((Object)e));
        }
    }

    private Configuration resolveToolClasspath(Object ... dependencyNotations) {
        List dependencies = CollectionUtils.collect((Object[])dependencyNotations, (Transformer)new Transformer<Dependency, Object>(){

            public Dependency transform(Object dependencyNotation) {
                return DefaultPlayToolChain.this.dependencyHandler.create(dependencyNotation);
            }
        });
        Dependency[] dependenciesArray = dependencies.toArray(new Dependency[0]);
        return this.configurationContainer.detachedConfiguration(dependenciesArray);
    }

    private static class UnavailablePlayToolProvider
    implements PlayToolProvider {
        private final Exception exception;

        public UnavailablePlayToolProvider(Exception exception) {
            this.exception = exception;
        }

        public <T extends CompileSpec> Compiler<T> newCompiler(Class<T> spec) {
            throw this.failure();
        }

        public <T> T get(Class<T> toolType) {
            throw this.failure();
        }

        public boolean isAvailable() {
            return false;
        }

        private RuntimeException failure() {
            TreeFormatter formatter = new TreeFormatter();
            this.explain((DiagnosticsVisitor)formatter);
            return new GradleException(formatter.toString());
        }

        public void explain(DiagnosticsVisitor visitor) {
            visitor.node("Cannot provide Play tool provider");
            visitor.startChildren();
            visitor.node(this.exception.getCause().getMessage());
            visitor.endChildren();
        }
    }
}

