/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal.resolve;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.configurations.OutgoingVariant;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.dsl.CapabilityNotationParserFactory;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionRules;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.CapabilitiesResolutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultCapabilitiesResolution;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultResolutionStrategy;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.notations.ComponentIdentifierParserFactory;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.locking.NoOpDependencyLockingProvider;
import org.gradle.jvm.internal.resolve.UsageKind;
import org.gradle.jvm.internal.resolve.VariantsMetaData;
import org.gradle.language.base.internal.model.DefaultLibraryLocalComponentMetadata;
import org.gradle.platform.base.DependencySpec;
import org.gradle.vcs.internal.VcsMappingsStore;

public class JvmLibraryResolveContext
implements ResolveContext {
    private final LibraryBinaryIdentifier libraryBinaryIdentifier;
    private final String displayName;
    private final UsageKind usage;
    private final ResolutionStrategyInternal resolutionStrategy;
    private final VariantsMetaData variants;
    private final Iterable<DependencySpec> dependencies;

    public JvmLibraryResolveContext(LibraryBinaryIdentifier libraryBinaryIdentifier, VariantsMetaData variants, Iterable<DependencySpec> dependencies, UsageKind usage, String displayName, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.libraryBinaryIdentifier = libraryBinaryIdentifier;
        this.usage = usage;
        this.displayName = displayName;
        this.variants = variants;
        this.dependencies = dependencies;
        this.resolutionStrategy = new DefaultResolutionStrategy(DependencySubstitutionRules.NO_OP, VcsMappingsStore.NO_OP, null, moduleIdentifierFactory, null, NoOpDependencyLockingProvider.getInstance(), (CapabilitiesResolutionInternal)new DefaultCapabilitiesResolution(new CapabilityNotationParserFactory(false).create(), new ComponentIdentifierParserFactory().create()));
    }

    public String getName() {
        return this.usage.getConfigurationName();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public VariantsMetaData getVariants() {
        return this.variants;
    }

    public ResolutionStrategyInternal getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    public ComponentResolveMetadata toRootComponentMetaData() {
        final DefaultLibraryLocalComponentMetadata componentMetadata = DefaultLibraryLocalComponentMetadata.newResolvingLocalComponentMetadata((LibraryBinaryIdentifier)this.libraryBinaryIdentifier, (String)this.usage.getConfigurationName(), this.dependencies);
        for (UsageKind usageKind : UsageKind.values()) {
            componentMetadata.addVariant(usageKind.getConfigurationName(), new OutgoingVariant(){

                public DisplayName asDescribable() {
                    return Describables.of((Object)componentMetadata.getId());
                }

                public AttributeContainerInternal getAttributes() {
                    return ImmutableAttributes.EMPTY;
                }

                public Set<? extends PublishArtifact> getArtifacts() {
                    return ImmutableSet.of();
                }

                public Set<? extends OutgoingVariant> getChildren() {
                    return ImmutableSet.of();
                }
            });
        }
        return componentMetadata;
    }

    public AttributeContainer getAttributes() {
        return ImmutableAttributes.EMPTY;
    }
}

