/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.DependencyLockingHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.RepositoryContentDescriptor;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.repositories.ArtifactRepositoryInternal;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.Factory;
import org.gradle.plugin.use.internal.PluginRepositoriesProvider;
import org.gradle.plugin.use.internal.PluginRepositoryHandlerProvider;

public class PluginDependencyResolutionServices
implements DependencyResolutionServices {
    private static final String REPOSITORY_NAME_PREFIX = "__plugin_repository__";
    private final Factory<DependencyResolutionServices> factory;
    private DependencyResolutionServices dependencyResolutionServices;

    public PluginDependencyResolutionServices(Factory<DependencyResolutionServices> factory) {
        this.factory = factory;
    }

    private DependencyResolutionServices getDependencyResolutionServices() {
        if (this.dependencyResolutionServices == null) {
            this.dependencyResolutionServices = (DependencyResolutionServices)this.factory.create();
        }
        return this.dependencyResolutionServices;
    }

    public RepositoryHandler getResolveRepositoryHandler() {
        return this.getDependencyResolutionServices().getResolveRepositoryHandler();
    }

    public ConfigurationContainer getConfigurationContainer() {
        return this.getDependencyResolutionServices().getConfigurationContainer();
    }

    public DependencyHandler getDependencyHandler() {
        return this.getDependencyResolutionServices().getDependencyHandler();
    }

    public DependencyLockingHandler getDependencyLockingHandler() {
        return this.getDependencyResolutionServices().getDependencyLockingHandler();
    }

    public ImmutableAttributesFactory getAttributesFactory() {
        return this.getDependencyResolutionServices().getAttributesFactory();
    }

    public AttributesSchema getAttributesSchema() {
        return this.getDependencyResolutionServices().getAttributesSchema();
    }

    public PluginRepositoryHandlerProvider getPluginRepositoryHandlerProvider() {
        return new PluginRepositoryHandlerProvider(){

            @Override
            public RepositoryHandler getPluginRepositoryHandler() {
                return PluginDependencyResolutionServices.this.getResolveRepositoryHandler();
            }
        };
    }

    public ObjectFactory getObjectFactory() {
        return this.getDependencyResolutionServices().getObjectFactory();
    }

    public PluginRepositoriesProvider getPluginRepositoriesProvider() {
        return new PluginRepositoriesProvider(){

            @Override
            public List<ArtifactRepository> getPluginRepositories() {
                RepositoryHandler repositories = PluginDependencyResolutionServices.this.getResolveRepositoryHandler();
                ArrayList<ArtifactRepository> list = new ArrayList<ArtifactRepository>(repositories.size());
                for (ArtifactRepository repository : repositories) {
                    list.add((ArtifactRepository)new PluginArtifactRepository(repository));
                }
                return list;
            }
        };
    }

    private static class PluginArtifactRepository
    implements ArtifactRepositoryInternal,
    ResolutionAwareRepository {
        private final ArtifactRepositoryInternal delegate;
        private final ResolutionAwareRepository resolutionAwareDelegate;

        private PluginArtifactRepository(ArtifactRepository delegate) {
            this.delegate = (ArtifactRepositoryInternal)delegate;
            this.resolutionAwareDelegate = (ResolutionAwareRepository)delegate;
        }

        public String getName() {
            return PluginDependencyResolutionServices.REPOSITORY_NAME_PREFIX + this.delegate.getName();
        }

        public void setName(String name) {
            this.delegate.setName(name);
        }

        public void content(Action<? super RepositoryContentDescriptor> configureAction) {
            this.delegate.content(configureAction);
        }

        public String getDisplayName() {
            return this.delegate.getDisplayName();
        }

        public ConfiguredModuleComponentRepository createResolver() {
            return this.resolutionAwareDelegate.createResolver();
        }

        public RepositoryDescriptor getDescriptor() {
            return this.resolutionAwareDelegate.getDescriptor();
        }

        public void onAddToContainer(NamedDomainObjectCollection<ArtifactRepository> container) {
            this.delegate.onAddToContainer(container);
        }
    }
}

