/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.typeinference.TypeSearchVarInfo;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class TypeSearchState {
    private Map<SSAVar, TypeSearchVarInfo> varInfoMap;

    public TypeSearchState(MethodNode mth) {
        List<SSAVar> vars = mth.getSVars();
        this.varInfoMap = new LinkedHashMap<SSAVar, TypeSearchVarInfo>(vars.size());
        for (SSAVar var : vars) {
            this.varInfoMap.put(var, new TypeSearchVarInfo(var));
        }
    }

    @NotNull
    public TypeSearchVarInfo getVarInfo(SSAVar var) {
        TypeSearchVarInfo varInfo = this.varInfoMap.get(var);
        if (varInfo == null) {
            throw new JadxRuntimeException("TypeSearchVarInfo not found in map for var: " + var);
        }
        return varInfo;
    }

    public List<TypeSearchVarInfo> getAllVars() {
        return new ArrayList<TypeSearchVarInfo>(this.varInfoMap.values());
    }

    public List<TypeSearchVarInfo> getUnresolvedVars() {
        return this.varInfoMap.values().stream().filter(varInfo -> !varInfo.isTypeResolved()).collect(Collectors.toList());
    }

    public List<TypeSearchVarInfo> getResolvedVars() {
        return this.varInfoMap.values().stream().filter(TypeSearchVarInfo::isTypeResolved).collect(Collectors.toList());
    }
}

