'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.collectDashboards = collectDashboards;

var _collect_panels = require('./collect_panels');

async function collectDashboards(savedObjectsClient, ids) {

  if (ids.length === 0) return [];

  const objects = ids.map(id => {
    return {
      type: 'dashboard',
      id: id
    };
  });

  const { saved_objects: savedObjects } = await savedObjectsClient.bulkGet(objects);
  const results = await Promise.all(savedObjects.map(d => (0, _collect_panels.collectPanels)(savedObjectsClient, d)));

  return results.reduce((acc, result) => acc.concat(result), []).reduce((acc, obj) => {
    if (!acc.find(o => o.id === obj.id)) acc.push(obj);
    return acc;
  }, []);
} /*
   * Licensed to Elasticsearch B.V. under one or more contributor
   * license agreements. See the NOTICE file distributed with
   * this work for additional information regarding copyright
   * ownership. Elasticsearch B.V. licenses this file to you under
   * the Apache License, Version 2.0 (the "License"); you may
   * not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *    http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing,
   * software distributed under the License is distributed on an
   * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
   * KIND, either express or implied.  See the License for the
   * specific language governing permissions and limitations
   * under the License.
   */