/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) * u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(17411940053607665273ul, 7225ul, 8836ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) * u64vec3(167ul, 66ul, 187ul)) => u64vec3(1305737782152034861ul, 5610ul, 17578ul)
 * (u64vec3(167ul, 66ul, 187ul) * u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(1305737782152034861ul, 5610ul, 17578ul)
 * (u64vec3(167ul, 66ul, 187ul) * u64vec3(167ul, 66ul, 187ul)) => u64vec3(27889ul, 4356ul, 34969ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) * u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(17411940053607665273ul, 7225ul, 8836ul))) ? 1 : -1] array0;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) * u64vec3(167ul, 66ul, 187ul)), u64vec3(1305737782152034861ul, 5610ul, 17578ul))) ? 1 : -1] array1;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) * u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(1305737782152034861ul, 5610ul, 17578ul))) ? 1 : -1] array2;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) * u64vec3(167ul, 66ul, 187ul)), u64vec3(27889ul, 4356ul, 34969ul))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
